/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.controllers.AbstractClusterLinkingConfigManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.ErrorUtils;
import io.confluent.kafkarest.controllers.LinkConfigManager;
import io.confluent.kafkarest.entities.AlterConfigCommand;
import io.confluent.kafkarest.entities.LinkConfig;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.config.ConfigResource;

final class LinkConfigManagerImpl
extends AbstractClusterLinkingConfigManager<LinkConfig, LinkConfig.Builder>
implements LinkConfigManager {
    @Inject
    LinkConfigManagerImpl(Admin adminClient, ClusterManager clusterManager) {
        super(adminClient, clusterManager);
    }

    @Override
    public CompletableFuture<List<LinkConfig>> listLinkConfigs(String clusterId, String linkName) {
        CompletableFuture result = this.listConfigs(clusterId, new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName), ((LinkConfig.Builder)LinkConfig.builder().setClusterId(clusterId)).setLinkName(linkName));
        return ErrorUtils.catchClusterLinkingExceptions(result);
    }

    @Override
    public CompletableFuture<Optional<LinkConfig>> getLinkConfig(String clusterId, String linkName, String name) {
        CompletableFuture result = this.getConfig(clusterId, new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName), ((LinkConfig.Builder)LinkConfig.builder().setClusterId(clusterId)).setLinkName(linkName), name);
        return ErrorUtils.catchClusterLinkingExceptions(result);
    }

    @Override
    public CompletableFuture<Void> updateLinkConfig(String clusterId, String linkName, String name, String newValue) {
        CompletableFuture result = this.safeUpdateConfig(clusterId, new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName), ((LinkConfig.Builder)LinkConfig.builder().setClusterId(clusterId)).setLinkName(linkName), name, newValue);
        return ErrorUtils.catchClusterLinkingExceptions(result);
    }

    @Override
    public CompletableFuture<Void> resetLinkConfig(String clusterId, String linkName, String configName) {
        CompletableFuture result = this.safeResetConfig(clusterId, new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName), ((LinkConfig.Builder)LinkConfig.builder().setClusterId(clusterId)).setLinkName(linkName), configName);
        return ErrorUtils.catchClusterLinkingExceptions(result);
    }

    @Override
    public CompletableFuture<Void> alterLinkConfigs(String clusterId, String linkName, List<AlterConfigCommand> commands, boolean validateOnly) {
        CompletableFuture<Void> result = this.safeAlterConfigs(clusterId, new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName), ((LinkConfig.Builder)LinkConfig.builder().setClusterId(clusterId)).setLinkName(linkName), commands, validateOnly);
        return ErrorUtils.catchClusterLinkingExceptions(result);
    }
}

