/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.common.CompletableFutures;
import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.controllers.ErrorUtils;
import io.confluent.kafkarest.controllers.MirrorManager;
import io.confluent.kafkarest.entities.AlterMirrors;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.entities.Mirror;
import io.confluent.kafkarest.entities.MirrorStatus;
import io.confluent.kafkarest.entities.TopicPartitionLag;
import io.confluent.kafkarest.entities.v3.PartitionTruncationInfo;
import io.confluent.kafkarest.exceptions.BadRequestException;
import io.confluent.kafkarest.exceptions.ClusterLinkNotFoundException;
import io.confluent.kafkarest.exceptions.MirrorInfoNotAvailableException;
import io.confluent.kafkarest.exceptions.MirrorTopicNotFoundException;
import io.confluent.kafkarest.exceptions.UnsupportedVersionException;
import io.confluent.kafkarest.resources.v3.MirrorResource;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.core.Response;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsResult;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MirrorManagerImpl
implements MirrorManager {
    private final ConfluentAdmin adminClient;
    private final ClusterManager clusterManager;
    private ListMirrorsOptions listOptions;
    private static final Logger log = LoggerFactory.getLogger(MirrorResource.class);
    private static final Duration DEFAULT_METADATA_TIMEOUT = Duration.ofSeconds(60L);
    private static final ListMirrorsOptions LIST_MIRRORS_OPTIONS = ((ListMirrorsOptions)new ListMirrorsOptions().timeoutMs(Integer.valueOf(Math.toIntExact(DEFAULT_METADATA_TIMEOUT.toMillis())))).includeStopped(true);
    private static final ReplicaStatusOptions REPLICA_STATUS_OPTIONS = (ReplicaStatusOptions)new ReplicaStatusOptions().timeoutMs(Integer.valueOf(Math.toIntExact(DEFAULT_METADATA_TIMEOUT.toMillis())));

    @Inject
    MirrorManagerImpl(ConfluentAdmin adminClient, ClusterManager clusterManager) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.clusterManager = Objects.requireNonNull(clusterManager);
    }

    @Override
    public CompletableFuture<List<Mirror>> listMirrors(String clusterId, MirrorStatus mirrorStatus) {
        return ((CompletableFuture)this.getValidCluster(clusterId).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.adminClient.listMirrors(LIST_MIRRORS_OPTIONS).result()))).thenCompose(mirrorTopicNames -> this.getMirrors((Collection<String>)mirrorTopicNames, mirrorStatus, false, false, null));
    }

    private CompletableFuture<List<Mirror>> listStoppedRemoteMirrorsWithPattern(String clusterId, String linkName, Pattern mirrorTopicNamePattern) {
        this.listOptions = ((ListMirrorsOptions)new ListMirrorsOptions().linkName(Optional.of(linkName)).timeoutMs(Integer.valueOf(Math.toIntExact(DEFAULT_METADATA_TIMEOUT.toMillis())))).includeStopped(true).listRemoteMirrors(true);
        return ((CompletableFuture)this.getValidCluster(clusterId).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.adminClient.listMirrors(this.listOptions).result()))).thenCompose(unfilteredMirrorTopicNames -> {
            Collection mirrorTopicNames = unfilteredMirrorTopicNames.stream().filter(name -> mirrorTopicNamePattern.matcher((CharSequence)name).matches()).collect(Collectors.toList());
            return this.getMirrors(mirrorTopicNames, null, false, true, linkName);
        });
    }

    private CompletableFuture<List<Mirror>> listUnstoppedMirrorsWithPattern(String clusterId, String linkName, Pattern mirrorTopicNamePattern) {
        this.listOptions = ((ListMirrorsOptions)new ListMirrorsOptions().linkName(Optional.of(linkName)).timeoutMs(Integer.valueOf(Math.toIntExact(DEFAULT_METADATA_TIMEOUT.toMillis())))).includeStopped(false);
        return ((CompletableFuture)this.getValidCluster(clusterId).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.adminClient.listMirrors(this.listOptions).result()))).thenCompose(unfilteredMirrorTopicNames -> {
            Collection mirrorTopicNames = unfilteredMirrorTopicNames.stream().filter(name -> mirrorTopicNamePattern.matcher((CharSequence)name).matches()).collect(Collectors.toList());
            return this.getMirrors(mirrorTopicNames, null, false, false, linkName);
        });
    }

    @Override
    public CompletableFuture<Optional<Mirror>> getMirror(String clusterId, String linkName, String mirrorTopicName, @Nullable Boolean includeStateTransitionErrors) {
        return ((CompletableFuture)this.getValidCluster(clusterId).thenCompose(cluster -> this.getMirrors(Collections.singletonList(mirrorTopicName), includeStateTransitionErrors, false, linkName))).thenApply(mirrors -> {
            if (mirrors.isEmpty()) {
                throw new MirrorTopicNotFoundException(mirrorTopicName);
            }
            return mirrors.stream().filter(mirror -> mirror.getLinkName().equals(linkName)).findAny();
        });
    }

    @Override
    public CompletableFuture<Void> createMirror(String clusterId, String linkName, String sourceTopicName, String mirrorTopicName, Map<String, Optional<String>> configs, Optional<Short> replicationFactor) {
        HashMap nullableConfigs = new HashMap();
        configs.forEach((key, value) -> nullableConfigs.put(key, value.orElse(null)));
        NewTopic newTopic = new NewTopic(mirrorTopicName, Optional.empty(), replicationFactor).configs(nullableConfigs).mirror(Optional.of(new NewMirrorTopic(linkName, sourceTopicName)));
        CompletionStage result = this.getValidCluster(clusterId).thenCompose(cluster -> KafkaFutures.toCompletableFuture((KafkaFuture)this.adminClient.createTopics(Collections.singletonList(newTopic)).all()));
        return ErrorUtils.catchClusterLinkingExceptions(result);
    }

    @Override
    public CompletableFuture<List<AlterMirrors>> pauseMirrors(String clusterId, String linkName, Set<String> mirrorTopicNames, String mirrorTopicNamePattern, boolean validateOnly) {
        return this.alterMirrors(clusterId, linkName, mirrorTopicNames, mirrorTopicNamePattern, validateOnly, false, AlterMirrorOp.PAUSE, Long.MAX_VALUE);
    }

    @Override
    public CompletableFuture<List<AlterMirrors>> resumeMirrors(String clusterId, String linkName, Set<String> mirrorTopicNames, String mirrorTopicNamePattern, boolean validateOnly) {
        return this.alterMirrors(clusterId, linkName, mirrorTopicNames, mirrorTopicNamePattern, validateOnly, false, AlterMirrorOp.RESUME, Long.MAX_VALUE);
    }

    @Override
    public CompletableFuture<List<AlterMirrors>> promoteMirrors(String clusterId, String linkName, Set<String> mirrorTopicNames, String mirrorTopicNamePattern, boolean validateOnly) {
        return this.alterMirrors(clusterId, linkName, mirrorTopicNames, mirrorTopicNamePattern, validateOnly, false, AlterMirrorOp.PROMOTE, 0L);
    }

    @Override
    public CompletableFuture<List<AlterMirrors>> failOverMirrors(String clusterId, String linkName, Set<String> mirrorTopicNames, String mirrorTopicNamePattern, boolean validateOnly) {
        return this.alterMirrors(clusterId, linkName, mirrorTopicNames, mirrorTopicNamePattern, validateOnly, false, AlterMirrorOp.FAILOVER, Long.MAX_VALUE);
    }

    @Override
    public CompletableFuture<List<AlterMirrors>> reverseAndStartMirrors(String clusterId, String linkName, Set<String> mirrorTopicNames, String mirrorTopicNamePattern, boolean validateOnly) {
        return this.alterMirrors(clusterId, linkName, mirrorTopicNames, mirrorTopicNamePattern, validateOnly, false, AlterMirrorOp.REVERSE_AND_START_REMOTE_MIRROR, Long.MAX_VALUE);
    }

    @Override
    public CompletableFuture<List<AlterMirrors>> reverseAndPauseMirrors(String clusterId, String linkName, Set<String> mirrorTopicNames, String mirrorTopicNamePattern, boolean validateOnly) {
        return this.alterMirrors(clusterId, linkName, mirrorTopicNames, mirrorTopicNamePattern, validateOnly, false, AlterMirrorOp.REVERSE_AND_PAUSE_REMOTE_MIRROR, Long.MAX_VALUE);
    }

    @Override
    public CompletableFuture<List<AlterMirrors>> truncateAndRestoreMirrors(String clusterId, String linkName, Set<String> mirrorTopicNames, String mirrorTopicNamePattern, boolean includePartitionLevelTruncationData, boolean validateOnly) {
        return this.alterMirrors(clusterId, linkName, mirrorTopicNames, mirrorTopicNamePattern, validateOnly, includePartitionLevelTruncationData, AlterMirrorOp.TRUNCATE_AND_RESTORE, Long.MAX_VALUE);
    }

    private CompletableFuture<List<Mirror>> getMirrors(Collection<String> mirrorTopicNames, Boolean includeStateTransitionErrors, Boolean isTruncateAndRestore, String linkName) {
        return this.getMirrors(mirrorTopicNames, null, includeStateTransitionErrors, isTruncateAndRestore, linkName);
    }

    private CompletableFuture<List<Mirror>> getMirrors(Collection<String> mirrorTopicNames, @Nullable MirrorStatus mirrorStatus, @Nullable Boolean includeStateTransitionErrors, Boolean isTruncateAndRestore, @Nullable String linkName) {
        DescribeMirrorsOptions options = (DescribeMirrorsOptions)new DescribeMirrorsOptions().describeRemoteMirrors(isTruncateAndRestore.booleanValue()).timeoutMs(Integer.valueOf(Math.toIntExact(DEFAULT_METADATA_TIMEOUT.toMillis())));
        if (linkName != null) {
            options = options.linkNames(Collections.singleton(linkName));
        }
        if (includeStateTransitionErrors != null) {
            options.includeStateTransitionErrors(includeStateTransitionErrors.booleanValue());
        }
        return MirrorManagerImpl.fromDescribeMirrorResult(this.adminClient.describeMirrors(mirrorTopicNames, options), mirrorStatus).thenCompose(mirrorWithoutPartitionLags -> {
            Set<TopicPartition> topicPartitions = MirrorManagerImpl.topicPartitionsFromNumPartitionsMap(MirrorManagerImpl.toNumPartitionsMap(mirrorWithoutPartitionLags));
            ReplicaStatusResult replicaStatusResult = this.adminClient.replicaStatus(topicPartitions, REPLICA_STATUS_OPTIONS);
            return this.composeFromReplicaStatusResult((List<Mirror>)mirrorWithoutPartitionLags, replicaStatusResult, isTruncateAndRestore);
        });
    }

    private CompletableFuture<List<AlterMirrors>> alterMirrors(String clusterId, String linkName, Set<String> mirrorTopicNames, String mirrorTopicNamePattern, boolean validateOnly, boolean includePartitionLevelTruncationData, AlterMirrorOp alterMirrorOperation, Long maxLagAllow) {
        if (mirrorTopicNames != null && mirrorTopicNamePattern != null) {
            throw new BadRequestException("both mirror_topic_names and mirror_topic_name_pattern are set");
        }
        if (mirrorTopicNames == null && mirrorTopicNamePattern == null) {
            throw new BadRequestException("either mirror_topic_names or mirror_topic_name_pattern should be set");
        }
        Pattern pattern = null;
        if (mirrorTopicNamePattern != null) {
            try {
                pattern = Pattern.compile(mirrorTopicNamePattern);
            }
            catch (PatternSyntaxException e) {
                throw new BadRequestException("invalid mirror_topic_name_pattern");
            }
        }
        AlterMirrorsOptions alterMirrorsOptions = ((AlterMirrorsOptions)new AlterMirrorsOptions().validateOnly(validateOnly).timeoutMs(Integer.valueOf(Math.toIntExact(DEFAULT_METADATA_TIMEOUT.toMillis())))).linkName(linkName).includePartitionLevelTruncationData(includePartitionLevelTruncationData);
        Pattern finalPattern = pattern;
        return ((CompletableFuture)this.getValidCluster(clusterId).thenCompose(cluster -> {
            boolean isTruncateAndRestore = false;
            if (alterMirrorOperation == AlterMirrorOp.TRUNCATE_AND_RESTORE) {
                isTruncateAndRestore = true;
            }
            if (mirrorTopicNamePattern == null) {
                return this.getMirrors(mirrorTopicNames, false, isTruncateAndRestore, linkName);
            }
            if (isTruncateAndRestore) {
                return this.listStoppedRemoteMirrorsWithPattern(clusterId, linkName, finalPattern);
            }
            return this.listUnstoppedMirrorsWithPattern(clusterId, linkName, finalPattern);
        })).thenCompose(mirrors -> this.alterMirrors(linkName, mirrorTopicNamePattern == null ? mirrorTopicNames : mirrors.stream().map(Mirror::getMirrorTopicName).collect(Collectors.toSet()), (List<Mirror>)mirrors, alterMirrorOperation, alterMirrorsOptions, maxLagAllow));
    }

    private CompletableFuture<List<AlterMirrors>> alterMirrors(String linkName, Set<String> mirrorTopicNames, List<Mirror> mirrorListing, AlterMirrorOp alterMirrorOperation, AlterMirrorsOptions alterMirrorsOptions, long maxLagAllow) {
        Map<String, Mirror> topicMirrors = MirrorManagerImpl.toMirrorTopics(mirrorListing);
        Set<String> laggingTopics = MirrorManagerImpl.toLaggingTopics(mirrorListing, maxLagAllow);
        HashMap<String, AlterMirrorOp> alterMirrorOperations = new HashMap<String, AlterMirrorOp>();
        LinkedList<AlterMirrors> alterMirrorsResult = new LinkedList<AlterMirrors>();
        for (String topicName : mirrorTopicNames) {
            if (laggingTopics.contains(topicName)) {
                alterMirrorsResult.add(AlterMirrors.create(topicName, Response.Status.BAD_REQUEST.getStatusCode(), this.laggingMessage(maxLagAllow), topicMirrors.get(topicName).getPartitionLagList(), -1L, Collections.emptyList()));
                continue;
            }
            if (!topicMirrors.containsKey(topicName)) {
                alterMirrorsResult.add(AlterMirrors.create(topicName, Response.Status.BAD_REQUEST.getStatusCode(), this.topicNotFoundMessage(topicName), Collections.emptyList(), -1L, Collections.emptyList()));
                continue;
            }
            if (!topicMirrors.get(topicName).getLinkName().equals(linkName)) {
                alterMirrorsResult.add(AlterMirrors.create(topicName, Response.Status.BAD_REQUEST.getStatusCode(), this.incorrectLinkMessage(topicName, linkName), Collections.emptyList(), -1L, Collections.emptyList()));
                continue;
            }
            alterMirrorOperations.put(topicName, alterMirrorOperation);
        }
        AlterMirrorsResult result = this.adminClient.alterMirrors(alterMirrorOperations, alterMirrorsOptions);
        CompletableFuture<List<AlterMirrors>> alterMirrorsFuture = MirrorManagerImpl.fromAlterMirrorResult(result, topicMirrors);
        return alterMirrorsFuture.thenApply(alterMirrors -> ImmutableList.builder().addAll((Iterable)alterMirrorsResult).addAll((Iterable)alterMirrors).build());
    }

    private CompletableFuture<List<AlterMirrors>> invalidMirrorTopicNamesAndPattern(String message) {
        ArrayList<AlterMirrors> alterMirrors = new ArrayList<AlterMirrors>();
        alterMirrors.add(AlterMirrors.create("", Response.Status.BAD_REQUEST.getStatusCode(), message, new ArrayList<TopicPartitionLag>(), -1L, Collections.emptyList()));
        return CompletableFuture.completedFuture(ImmutableList.builder().addAll(alterMirrors).build());
    }

    private String incorrectLinkMessage(String topic, String linkName) {
        return String.format("Mirror topic %s does not belongs to link %s", topic, linkName);
    }

    private String topicNotFoundMessage(String topic) {
        return String.format("Mirror topic %s not found", topic);
    }

    private String laggingMessage(Long maxLagAllow) {
        return String.format("Operation failed because some partitions have mirror lag greater than %s", maxLagAllow);
    }

    private static CompletableFuture<List<Mirror>> fromDescribeMirrorResult(DescribeMirrorsResult result, @Nullable MirrorStatus mirrorStatus) {
        return CompletableFutures.allAsList(result.result().entrySet().stream().map(entry -> KafkaFutures.toCompletableFuture((KafkaFuture)((KafkaFuture)entry.getValue())).handle((topicMirrorDescription, throwable) -> {
            if (throwable == null && topicMirrorDescription != null) {
                if (!MirrorManagerImpl.mirrorStatusMatched(mirrorStatus, topicMirrorDescription)) {
                    return null;
                }
                return Mirror.create(topicMirrorDescription.linkName(), (String)entry.getKey(), topicMirrorDescription.mirrorTopic(), topicMirrorDescription.numPartitions(), Collections.emptyList(), topicMirrorDescription.state(), topicMirrorDescription.mirrorTopicError(), topicMirrorDescription.stateTimeMs(), topicMirrorDescription.stoppedLogEndOffsets(), topicMirrorDescription.mirrorStateTransitionErrors());
            }
            if (throwable == null && topicMirrorDescription == null) {
                return null;
            }
            if (throwable instanceof UnknownTopicOrPartitionException || throwable instanceof AuthorizationException) {
                return null;
            }
            if (throwable instanceof TimeoutException) {
                throw new io.confluent.kafkarest.exceptions.TimeoutException((Throwable)throwable);
            }
            if (throwable instanceof org.apache.kafka.common.errors.ClusterLinkNotFoundException) {
                throw new ClusterLinkNotFoundException((Throwable)throwable);
            }
            if (throwable instanceof InvalidClusterLinkException) {
                throw new io.confluent.kafkarest.exceptions.InvalidClusterLinkException((InvalidClusterLinkException)throwable);
            }
            if (throwable instanceof org.apache.kafka.common.errors.UnsupportedVersionException) {
                throw new UnsupportedVersionException(throwable.getMessage());
            }
            log.warn("Unexpected error happens during describing mirror", throwable);
            throw new InternalServerErrorException(throwable);
        })).collect(Collectors.toList())).thenApply(mirrors -> mirrors.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static boolean mirrorStatusMatched(@Nullable MirrorStatus mirrorStatus, MirrorTopicDescription topicMirrorDescription) {
        return mirrorStatus == null || mirrorStatus.getState() == topicMirrorDescription.state();
    }

    private static CompletableFuture<List<AlterMirrors>> fromAlterMirrorResult(AlterMirrorsResult result, Map<String, Mirror> topicMirrors) {
        if (result.values() == null) {
            return MirrorManagerImpl.fromAlterMirrorResultTruncateAndRestore(result, topicMirrors);
        }
        return CompletableFutures.allAsList(result.values().entrySet().stream().map(entry -> KafkaFutures.toCompletableFuture((KafkaFuture)((KafkaFuture)entry.getValue())).handle((unused, throwable) -> {
            Response.Status status;
            if (throwable == null) {
                return AlterMirrors.create((String)entry.getKey(), null, null, ((Mirror)topicMirrors.get(entry.getKey())).getPartitionLagList(), -1L, Collections.emptyList());
            }
            String errorMessage = throwable.getMessage();
            if (throwable instanceof ExecutionException) {
                Throwable cause = throwable.getCause();
                if (cause instanceof InvalidRequestException || cause instanceof UnknownTopicOrPartitionException) {
                    status = Response.Status.BAD_REQUEST;
                } else if (cause instanceof AuthorizationException) {
                    status = Response.Status.UNAUTHORIZED;
                } else if (cause instanceof TimeoutException) {
                    status = Response.Status.REQUEST_TIMEOUT;
                } else {
                    log.warn("Unexpected execution exception during altering mirror", throwable);
                    status = Response.Status.INTERNAL_SERVER_ERROR;
                }
            } else if (throwable instanceof InvalidRequestException) {
                status = Response.Status.BAD_REQUEST;
            } else {
                log.warn("Unexpected error happens during altering mirror", throwable);
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
            return AlterMirrors.create((String)entry.getKey(), status.getStatusCode(), errorMessage, Collections.emptyList(), -1L, Collections.emptyList());
        })).collect(Collectors.toList()));
    }

    private static CompletableFuture<List<AlterMirrors>> fromAlterMirrorResultTruncateAndRestore(AlterMirrorsResult result, Map<String, Mirror> topicMirrors) {
        return CompletableFutures.allAsList(result.truncateAndRestoreValues().entrySet().stream().map(entry -> KafkaFutures.toCompletableFuture((KafkaFuture)((KafkaFuture)entry.getValue())).handle((truncationInformation, throwable) -> {
            Response.Status status;
            if (throwable == null) {
                LinkedList<PartitionTruncationInfo> partitionTruncationInfoList = new LinkedList();
                if (truncationInformation.partitionLevelTruncationData() != null) {
                    partitionTruncationInfoList = truncationInformation.partitionLevelTruncationData().stream().map(data -> PartitionTruncationInfo.fromResponseTruncationData(data)).collect(Collectors.toList());
                }
                return AlterMirrors.create((String)entry.getKey(), null, null, ((Mirror)topicMirrors.get(entry.getKey())).getPartitionLagList(), truncationInformation.messagesTruncated(), partitionTruncationInfoList);
            }
            String errorMessage = throwable.getMessage();
            if (throwable instanceof ExecutionException) {
                Throwable cause = throwable.getCause();
                if (cause instanceof InvalidRequestException || cause instanceof UnknownTopicOrPartitionException) {
                    status = Response.Status.BAD_REQUEST;
                } else if (cause instanceof AuthorizationException) {
                    status = Response.Status.UNAUTHORIZED;
                } else if (cause instanceof TimeoutException) {
                    status = Response.Status.REQUEST_TIMEOUT;
                } else {
                    log.warn("Unexpected execution exception during altering mirror", throwable);
                    status = Response.Status.INTERNAL_SERVER_ERROR;
                }
            } else if (throwable instanceof InvalidRequestException) {
                status = Response.Status.BAD_REQUEST;
            } else {
                log.warn("Unexpected error happens during altering mirror", throwable);
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
            return AlterMirrors.create((String)entry.getKey(), status.getStatusCode(), errorMessage, Collections.emptyList(), -1L, Collections.emptyList());
        })).collect(Collectors.toList()));
    }

    private CompletableFuture<List<Mirror>> composeFromReplicaStatusResult(List<Mirror> mirrorsWithoutPartitionLags, ReplicaStatusResult replicaStatusResult, Boolean isTruncateAndRestore) {
        return this.calculateMirrorLags(replicaStatusResult, isTruncateAndRestore).thenApply(topicPartitionLags -> {
            ArrayList<Mirror> finalizedMirrors = new ArrayList<Mirror>();
            for (Mirror mirrorWithoutPartitionLags : mirrorsWithoutPartitionLags) {
                List<TopicPartitionLag> partitionLags = topicPartitionLags.stream().filter(topicPartitionLag -> topicPartitionLag.getTopicPartition().topic().equals(mirrorWithoutPartitionLags.getMirrorTopicName())).map(topicPartitionLag -> this.getTopicPartitionLag((TopicPartitionLag)topicPartitionLag, mirrorWithoutPartitionLags)).collect(Collectors.toList());
                finalizedMirrors.add(Mirror.create(mirrorWithoutPartitionLags.getLinkName(), mirrorWithoutPartitionLags.getMirrorTopicName(), mirrorWithoutPartitionLags.getSourceTopicName(), mirrorWithoutPartitionLags.getNumPartitions(), partitionLags, mirrorWithoutPartitionLags.getMirrorStatus(), mirrorWithoutPartitionLags.getMirrorTopicError(), mirrorWithoutPartitionLags.getStatusTimeMs(), mirrorWithoutPartitionLags.getStoppedLogEndOffsets(), mirrorWithoutPartitionLags.getMirrorStateTransitionErrors()));
            }
            return finalizedMirrors;
        });
    }

    private TopicPartitionLag getTopicPartitionLag(TopicPartitionLag partitionLag, Mirror mirror) {
        MirrorTopicDescription.State mirrorState = mirror.getMirrorStatus();
        if (mirrorState == MirrorTopicDescription.State.STOPPED && partitionLag.getTopicPartition().partition() < mirror.getStoppedLogEndOffsets().size()) {
            return TopicPartitionLag.create(partitionLag.getTopicPartition(), 0L, mirror.getStoppedLogEndOffsets().get(partitionLag.getTopicPartition().partition()));
        }
        if (mirrorState == MirrorTopicDescription.State.PAUSED || mirrorState == MirrorTopicDescription.State.LINK_PAUSED || mirrorState == MirrorTopicDescription.State.SOURCE_UNAVAILABLE || mirrorState == MirrorTopicDescription.State.UNKNOWN) {
            return TopicPartitionLag.create(partitionLag.getTopicPartition(), -1L, -1L);
        }
        return partitionLag;
    }

    private CompletableFuture<List<TopicPartitionLag>> calculateMirrorLags(ReplicaStatusResult replicaStatusResult, Boolean isTruncateAndRestore) {
        if (replicaStatusResult.result().isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFutures.allAsList(replicaStatusResult.result().entrySet().stream().map(entry -> KafkaFutures.toCompletableFuture((KafkaFuture)((KafkaFuture)entry.getValue())).handle((statuses, throwable) -> {
            if (throwable != null) {
                log.warn("Error happens during fetching replica status", throwable);
                throw new InternalServerErrorException("Replica status is temporarily unavailable.");
            }
            if (isTruncateAndRestore.booleanValue()) {
                List topicPartitionLags = statuses.stream().filter(ReplicaStatus::isLeader).map(status -> this.truncateAndRestoreTopicLag((TopicPartition)entry.getKey(), (ReplicaStatus)status)).collect(Collectors.toList());
                return (TopicPartitionLag)topicPartitionLags.get(0);
            }
            List filteredStatuses = statuses.stream().filter(status -> status.mirrorInfo().isPresent()).filter(ReplicaStatus::isLeader).map(status -> this.toTopicPartitionLag((TopicPartition)entry.getKey(), (ReplicaStatus)status)).collect(Collectors.toList());
            if (filteredStatuses.isEmpty()) {
                log.warn("Error happens when replica status doesn't have mirror info populated for {}", entry.getKey());
                throw new MirrorInfoNotAvailableException(((TopicPartition)entry.getKey()).toString());
            }
            return (TopicPartitionLag)filteredStatuses.get(0);
        })).collect(Collectors.toList()));
    }

    private TopicPartitionLag toTopicPartitionLag(TopicPartition topicPartition, ReplicaStatus status) {
        long sourceHighWaterMark = ((ReplicaStatus.MirrorInfo)status.mirrorInfo().orElseThrow(() -> new InternalServerErrorException("Mirror info is temporarily unavailable."))).lastFetchSourceHighWatermark();
        long destLogEndOffset = status.logEndOffset();
        return TopicPartitionLag.create(topicPartition, Long.max(-1L, sourceHighWaterMark - destLogEndOffset), sourceHighWaterMark);
    }

    private TopicPartitionLag truncateAndRestoreTopicLag(TopicPartition topicPartition, ReplicaStatus status) {
        return TopicPartitionLag.create(topicPartition, -1L, status.logEndOffset());
    }

    private static Set<TopicPartition> topicPartitionsFromNumPartitionsMap(Map<String, Integer> numPartitions) {
        HashSet<TopicPartition> tps = new HashSet<TopicPartition>();
        for (Map.Entry<String, Integer> entry : numPartitions.entrySet()) {
            for (int partition = 0; partition < entry.getValue(); ++partition) {
                tps.add(new TopicPartition(entry.getKey(), partition));
            }
        }
        return tps;
    }

    private static Map<String, Integer> toNumPartitionsMap(List<Mirror> mirrors) {
        return mirrors.stream().collect(Collectors.toMap(Mirror::getMirrorTopicName, Mirror::getNumPartitions));
    }

    private static Map<String, Mirror> toMirrorTopics(List<Mirror> mirrors) {
        return mirrors.stream().collect(Collectors.toMap(Mirror::getMirrorTopicName, Function.identity()));
    }

    private static Set<String> toLaggingTopics(List<Mirror> mirrors, Long maxLagAllow) {
        return mirrors.stream().filter(mirror -> mirror.getPartitionLagList().stream().anyMatch(partitionLag -> partitionLag.getLag() > maxLagAllow)).map(Mirror::getMirrorTopicName).collect(Collectors.toSet());
    }

    private CompletableFuture<Cluster> getValidCluster(String clusterId) {
        return this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}));
    }

    ListMirrorsOptions getlistOptions() {
        return this.listOptions;
    }

    void setListOptions(ListMirrorsOptions listOptions) {
        this.listOptions = listOptions;
    }
}

