/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import com.google.common.collect.ImmutableSet;
import io.confluent.kafkarest.common.CompletableFutures;
import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.controllers.ReplicaStatusManager;
import io.confluent.kafkarest.controllers.TopicManager;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.entities.Topic;
import io.confluent.kafkarest.exceptions.TopicPartitionNotFoundException;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.replica.ReplicaStatus;

final class ReplicaStatusManagerImpl
implements ReplicaStatusManager {
    private final TopicManager topicManager;
    private final ClusterManager clusterManager;
    private final ConfluentAdmin confluentAdminClient;

    @Inject
    ReplicaStatusManagerImpl(ClusterManager clusterManager, ConfluentAdmin confluentAdminClient, TopicManager topicManager) {
        this.topicManager = Objects.requireNonNull(topicManager);
        this.clusterManager = Objects.requireNonNull(clusterManager);
        this.confluentAdminClient = Objects.requireNonNull(confluentAdminClient);
    }

    @Override
    public CompletableFuture<List<io.confluent.kafkarest.entities.ReplicaStatus>> listPartitionReplicaStatus(String clusterId, String topicName, int partitionId) {
        return ReplicaStatusManagerImpl.catchUnknownTopicPartitionException(((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists((Optional)cluster, (String)"Cluster %s cannot be found.", (Object[])new Object[]{clusterId}))).thenCompose(cluster -> {
            TopicPartition topicPartition = new TopicPartition(topicName, partitionId);
            return KafkaFutures.toCompletableFuture((KafkaFuture)((KafkaFuture)this.confluentAdminClient.replicaStatus((Set)ImmutableSet.of((Object)topicPartition), new ReplicaStatusOptions()).result().get(topicPartition))).thenApply(replicaStatuses -> replicaStatuses.stream().map(replicaStatus -> ReplicaStatusManagerImpl.toReplicaStatus(clusterId, topicName, partitionId, replicaStatus)).collect(Collectors.toList()));
        }), clusterId, topicName, Optional.of(partitionId));
    }

    @Override
    public CompletableFuture<List<io.confluent.kafkarest.entities.ReplicaStatus>> listTopicReplicaStatus(String clusterId, String topicName) {
        return ReplicaStatusManagerImpl.catchUnknownTopicPartitionException(this.topicManager.getTopic(clusterId, topicName).thenCompose(topic -> {
            Set topicPartitions = ((Topic)topic.orElseThrow(UnknownTopicOrPartitionException::new)).getPartitions().stream().map(partition -> new TopicPartition(partition.getTopicName(), partition.getPartitionId())).collect(Collectors.toSet());
            List<CompletableFuture> replicaStatusFutures = this.confluentAdminClient.replicaStatus(topicPartitions, new ReplicaStatusOptions()).result().entrySet().stream().map(partitionReplicaStatusEntry -> KafkaFutures.toCompletableFuture((KafkaFuture)((KafkaFuture)partitionReplicaStatusEntry.getValue())).thenApply(replicaStats -> replicaStats.stream().map(replicaStatus -> ReplicaStatusManagerImpl.toReplicaStatus(clusterId, topicName, ((TopicPartition)partitionReplicaStatusEntry.getKey()).partition(), replicaStatus)).collect(Collectors.toList()))).collect(Collectors.toList());
            CompletableFuture<Void> allFutures = CompletableFuture.allOf(replicaStatusFutures.toArray(new CompletableFuture[replicaStatusFutures.size()]));
            return allFutures.thenApply(future -> replicaStatusFutures.stream().flatMap(fut -> ((List)fut.join()).stream()).collect(Collectors.toList()));
        }), clusterId, topicName, Optional.empty());
    }

    @Override
    public CompletableFuture<List<io.confluent.kafkarest.entities.ReplicaStatus>> listClusterReplicaStatus(String clusterId) {
        return this.topicManager.listTopics(clusterId).thenCompose(topics -> {
            Set topicPartitions = topics.stream().flatMap(t -> t.getPartitions().stream()).map(p -> p.toTopicPartition()).collect(Collectors.toSet());
            List replicaStatusFutures = this.confluentAdminClient.replicaStatus(topicPartitions, new ReplicaStatusOptions()).result().entrySet().stream().map(partitionReplicaStatusEntry -> KafkaFutures.toCompletableFuture((KafkaFuture)((KafkaFuture)partitionReplicaStatusEntry.getValue())).thenApply(replicaStats -> replicaStats.stream().map(replicaStatus -> ReplicaStatusManagerImpl.toReplicaStatus(clusterId, ((TopicPartition)partitionReplicaStatusEntry.getKey()).topic(), ((TopicPartition)partitionReplicaStatusEntry.getKey()).partition(), replicaStatus)).collect(Collectors.toList()))).collect(Collectors.toList());
            CompletableFuture allFutures = CompletableFutures.allAsList(replicaStatusFutures);
            return allFutures.thenApply(future -> future.stream().flatMap(fut -> fut.stream()).collect(Collectors.toList()));
        });
    }

    private static io.confluent.kafkarest.entities.ReplicaStatus toReplicaStatus(String clusterId, String topicName, int partitionId, ReplicaStatus replicaStatus) {
        return io.confluent.kafkarest.entities.ReplicaStatus.builder().setClusterId(clusterId).setTopicName(topicName).setPartitionId(partitionId).setBrokerId(replicaStatus.brokerId()).setLeader(replicaStatus.isLeader()).setObserver(replicaStatus.isObserver()).setIsrEligible(replicaStatus.isIsrEligible()).setInIsr(replicaStatus.isInIsr()).setCaughtUp(replicaStatus.isCaughtUp()).setLogStartOffset(replicaStatus.logStartOffset()).setLogEndOffset(replicaStatus.logEndOffset()).setLastCaughtUpTimeMs(replicaStatus.lastCaughtUpTimeMs()).setLastFetchTimeMs(replicaStatus.lastFetchTimeMs()).setLinkName(replicaStatus.linkName().orElse(null)).build();
    }

    static <T> CompletableFuture<T> catchUnknownTopicPartitionException(CompletableFuture<T> future, String clusterId, String topicName, Optional<Integer> partitionId) {
        return CompletableFutures.catchingCompose(future, UnknownTopicOrPartitionException.class, e -> {
            throw new TopicPartitionNotFoundException(clusterId, topicName, partitionId, e.getMessage());
        });
    }
}

