/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import io.confluent.kafkarest.entities.AlterBrokerReplicaExclusion;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.apache.kafka.clients.admin.ExclusionOp;

final class AutoValue_AlterBrokerReplicaExclusion
extends AlterBrokerReplicaExclusion {
    private final String clusterId;
    private final int brokerId;
    private final ExclusionOp.OpType exclusion;
    private final String reason;
    private final Optional<Short> errorCode;
    private final Optional<String> errorMessage;

    private AutoValue_AlterBrokerReplicaExclusion(String clusterId, int brokerId, ExclusionOp.OpType exclusion, String reason, Optional<Short> errorCode, Optional<String> errorMessage) {
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.exclusion = exclusion;
        this.reason = reason;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public int getBrokerId() {
        return this.brokerId;
    }

    @Override
    public ExclusionOp.OpType getExclusion() {
        return this.exclusion;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public Optional<Short> getErrorCode() {
        return this.errorCode;
    }

    @Override
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "AlterBrokerReplicaExclusion{clusterId=" + this.clusterId + ", brokerId=" + this.brokerId + ", exclusion=" + String.valueOf(this.exclusion) + ", reason=" + this.reason + ", errorCode=" + String.valueOf(this.errorCode) + ", errorMessage=" + String.valueOf(this.errorMessage) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AlterBrokerReplicaExclusion) {
            AlterBrokerReplicaExclusion that = (AlterBrokerReplicaExclusion)o;
            return this.clusterId.equals(that.getClusterId()) && this.brokerId == that.getBrokerId() && this.exclusion.equals((Object)that.getExclusion()) && this.reason.equals(that.getReason()) && this.errorCode.equals(that.getErrorCode()) && this.errorMessage.equals(that.getErrorMessage());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerId;
        h$ *= 1000003;
        h$ ^= this.exclusion.hashCode();
        h$ *= 1000003;
        h$ ^= this.reason.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorCode.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorMessage.hashCode();
    }

    static final class Builder
    extends AlterBrokerReplicaExclusion.Builder {
        private String clusterId;
        private Integer brokerId;
        private ExclusionOp.OpType exclusion;
        private String reason;
        private Optional<Short> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();

        Builder() {
        }

        @Override
        public AlterBrokerReplicaExclusion.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public AlterBrokerReplicaExclusion.Builder setBrokerId(int brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        @Override
        public AlterBrokerReplicaExclusion.Builder setExclusion(ExclusionOp.OpType exclusion) {
            if (exclusion == null) {
                throw new NullPointerException("Null exclusion");
            }
            this.exclusion = exclusion;
            return this;
        }

        @Override
        public AlterBrokerReplicaExclusion.Builder setReason(String reason) {
            if (reason == null) {
                throw new NullPointerException("Null reason");
            }
            this.reason = reason;
            return this;
        }

        @Override
        public AlterBrokerReplicaExclusion.Builder setErrorCode(@Nullable Short errorCode) {
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        @Override
        public AlterBrokerReplicaExclusion.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        public AlterBrokerReplicaExclusion build() {
            Object missing = "";
            if (this.clusterId == null) {
                missing = (String)missing + " clusterId";
            }
            if (this.brokerId == null) {
                missing = (String)missing + " brokerId";
            }
            if (this.exclusion == null) {
                missing = (String)missing + " exclusion";
            }
            if (this.reason == null) {
                missing = (String)missing + " reason";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_AlterBrokerReplicaExclusion(this.clusterId, this.brokerId, this.exclusion, this.reason, this.errorCode, this.errorMessage);
        }
    }
}

