/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import io.confluent.kafkarest.entities.BrokerReplicaExclusion;
import jakarta.annotation.Nullable;
import java.util.Optional;

final class AutoValue_BrokerReplicaExclusion
extends BrokerReplicaExclusion {
    private final String clusterId;
    private final int brokerId;
    private final String reason;
    private final Optional<Short> errorCode;
    private final Optional<String> errorMessage;

    private AutoValue_BrokerReplicaExclusion(String clusterId, int brokerId, String reason, Optional<Short> errorCode, Optional<String> errorMessage) {
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.reason = reason;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public int getBrokerId() {
        return this.brokerId;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public Optional<Short> getErrorCode() {
        return this.errorCode;
    }

    @Override
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "BrokerReplicaExclusion{clusterId=" + this.clusterId + ", brokerId=" + this.brokerId + ", reason=" + this.reason + ", errorCode=" + String.valueOf(this.errorCode) + ", errorMessage=" + String.valueOf(this.errorMessage) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BrokerReplicaExclusion) {
            BrokerReplicaExclusion that = (BrokerReplicaExclusion)o;
            return this.clusterId.equals(that.getClusterId()) && this.brokerId == that.getBrokerId() && this.reason.equals(that.getReason()) && this.errorCode.equals(that.getErrorCode()) && this.errorMessage.equals(that.getErrorMessage());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerId;
        h$ *= 1000003;
        h$ ^= this.reason.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorCode.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorMessage.hashCode();
    }

    static final class Builder
    extends BrokerReplicaExclusion.Builder {
        private String clusterId;
        private Integer brokerId;
        private String reason;
        private Optional<Short> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();

        Builder() {
        }

        @Override
        public BrokerReplicaExclusion.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public BrokerReplicaExclusion.Builder setBrokerId(int brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        @Override
        public BrokerReplicaExclusion.Builder setReason(String reason) {
            if (reason == null) {
                throw new NullPointerException("Null reason");
            }
            this.reason = reason;
            return this;
        }

        @Override
        public BrokerReplicaExclusion.Builder setErrorCode(@Nullable Short errorCode) {
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        @Override
        public BrokerReplicaExclusion.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        public BrokerReplicaExclusion build() {
            Object missing = "";
            if (this.clusterId == null) {
                missing = (String)missing + " clusterId";
            }
            if (this.brokerId == null) {
                missing = (String)missing + " brokerId";
            }
            if (this.reason == null) {
                missing = (String)missing + " reason";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_BrokerReplicaExclusion(this.clusterId, this.brokerId, this.reason, this.errorCode, this.errorMessage);
        }
    }
}

