/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import io.confluent.kafkarest.entities.CellState;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.message.DescribeCellsResponseData;

final class AutoValue_CellState
extends CellState {
    private final String clusterId;
    private final List<DescribeCellsResponseData.Cell> cells;
    private final boolean cellsEnabled;
    private final Optional<Short> errorCode;
    private final Optional<String> errorMessage;

    private AutoValue_CellState(String clusterId, List<DescribeCellsResponseData.Cell> cells, boolean cellsEnabled, Optional<Short> errorCode, Optional<String> errorMessage) {
        this.clusterId = clusterId;
        this.cells = cells;
        this.cellsEnabled = cellsEnabled;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public List<DescribeCellsResponseData.Cell> getCells() {
        return this.cells;
    }

    @Override
    public boolean getCellsEnabled() {
        return this.cellsEnabled;
    }

    @Override
    public Optional<Short> getErrorCode() {
        return this.errorCode;
    }

    @Override
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "CellState{clusterId=" + this.clusterId + ", cells=" + String.valueOf(this.cells) + ", cellsEnabled=" + this.cellsEnabled + ", errorCode=" + String.valueOf(this.errorCode) + ", errorMessage=" + String.valueOf(this.errorMessage) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CellState) {
            CellState that = (CellState)o;
            return this.clusterId.equals(that.getClusterId()) && this.cells.equals(that.getCells()) && this.cellsEnabled == that.getCellsEnabled() && this.errorCode.equals(that.getErrorCode()) && this.errorMessage.equals(that.getErrorMessage());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.cells.hashCode();
        h$ *= 1000003;
        h$ ^= this.cellsEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.errorCode.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorMessage.hashCode();
    }

    static final class Builder
    extends CellState.Builder {
        private String clusterId;
        private List<DescribeCellsResponseData.Cell> cells;
        private Boolean cellsEnabled;
        private Optional<Short> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();

        Builder() {
        }

        @Override
        public CellState.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public CellState.Builder setCells(List<DescribeCellsResponseData.Cell> cells) {
            if (cells == null) {
                throw new NullPointerException("Null cells");
            }
            this.cells = cells;
            return this;
        }

        @Override
        public CellState.Builder setCellsEnabled(Boolean cellsEnabled) {
            if (cellsEnabled == null) {
                throw new NullPointerException("Null cellsEnabled");
            }
            this.cellsEnabled = cellsEnabled;
            return this;
        }

        @Override
        public CellState.Builder setErrorCode(@Nullable Short errorCode) {
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        @Override
        public CellState.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        public CellState build() {
            Object missing = "";
            if (this.clusterId == null) {
                missing = (String)missing + " clusterId";
            }
            if (this.cells == null) {
                missing = (String)missing + " cells";
            }
            if (this.cellsEnabled == null) {
                missing = (String)missing + " cellsEnabled";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_CellState(this.clusterId, this.cells, this.cellsEnabled, this.errorCode, this.errorMessage);
        }
    }
}

