/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.Link;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskDescription;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.replica.ReplicaStatus;

final class AutoValue_Link
extends Link {
    private final String remoteClusterId;
    private final String linkName;
    private final UUID linkId;
    private final Uuid clusterLinkId;
    private final ClusterLinkDescription.LinkMode linkMode;
    private final ImmutableList<String> topics;
    private final ClusterLinkError linkError;
    private final String linkErrorMessage;
    private final ClusterLinkDescription.LinkState linkState;
    private final ImmutableList<ClusterLinkTaskDescription> tasks;
    private final ClusterLinkDescription.LinkState remoteLinkState;
    private final Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> categoryCounts;

    private AutoValue_Link(String remoteClusterId, String linkName, UUID linkId, Uuid clusterLinkId, ClusterLinkDescription.LinkMode linkMode, ImmutableList<String> topics, ClusterLinkError linkError, String linkErrorMessage, ClusterLinkDescription.LinkState linkState, ImmutableList<ClusterLinkTaskDescription> tasks, ClusterLinkDescription.LinkState remoteLinkState, @Nullable Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> categoryCounts) {
        this.remoteClusterId = remoteClusterId;
        this.linkName = linkName;
        this.linkId = linkId;
        this.clusterLinkId = clusterLinkId;
        this.linkMode = linkMode;
        this.topics = topics;
        this.linkError = linkError;
        this.linkErrorMessage = linkErrorMessage;
        this.linkState = linkState;
        this.tasks = tasks;
        this.remoteLinkState = remoteLinkState;
        this.categoryCounts = categoryCounts;
    }

    @Override
    public String getRemoteClusterId() {
        return this.remoteClusterId;
    }

    @Override
    public String getLinkName() {
        return this.linkName;
    }

    @Override
    public UUID getLinkId() {
        return this.linkId;
    }

    @Override
    public Uuid getClusterLinkId() {
        return this.clusterLinkId;
    }

    @Override
    public ClusterLinkDescription.LinkMode getLinkMode() {
        return this.linkMode;
    }

    @Override
    public ImmutableList<String> getTopics() {
        return this.topics;
    }

    @Override
    public ClusterLinkError getLinkError() {
        return this.linkError;
    }

    @Override
    public String getLinkErrorMessage() {
        return this.linkErrorMessage;
    }

    @Override
    public ClusterLinkDescription.LinkState getLinkState() {
        return this.linkState;
    }

    @Override
    public ImmutableList<ClusterLinkTaskDescription> getTasks() {
        return this.tasks;
    }

    @Override
    public ClusterLinkDescription.LinkState getRemoteLinkState() {
        return this.remoteLinkState;
    }

    @Override
    @Nullable
    public Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> getCategoryCounts() {
        return this.categoryCounts;
    }

    public String toString() {
        return "Link{remoteClusterId=" + this.remoteClusterId + ", linkName=" + this.linkName + ", linkId=" + String.valueOf(this.linkId) + ", clusterLinkId=" + String.valueOf(this.clusterLinkId) + ", linkMode=" + String.valueOf(this.linkMode) + ", topics=" + String.valueOf(this.topics) + ", linkError=" + String.valueOf(this.linkError) + ", linkErrorMessage=" + this.linkErrorMessage + ", linkState=" + String.valueOf(this.linkState) + ", tasks=" + String.valueOf(this.tasks) + ", remoteLinkState=" + String.valueOf(this.remoteLinkState) + ", categoryCounts=" + String.valueOf(this.categoryCounts) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Link) {
            Link that = (Link)o;
            return this.remoteClusterId.equals(that.getRemoteClusterId()) && this.linkName.equals(that.getLinkName()) && this.linkId.equals(that.getLinkId()) && this.clusterLinkId.equals((Object)that.getClusterLinkId()) && this.linkMode.equals((Object)that.getLinkMode()) && this.topics.equals(that.getTopics()) && this.linkError.equals((Object)that.getLinkError()) && this.linkErrorMessage.equals(that.getLinkErrorMessage()) && this.linkState.equals((Object)that.getLinkState()) && this.tasks.equals(that.getTasks()) && this.remoteLinkState.equals((Object)that.getRemoteLinkState()) && (this.categoryCounts == null ? that.getCategoryCounts() == null : this.categoryCounts.equals(that.getCategoryCounts()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.remoteClusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.linkName.hashCode();
        h$ *= 1000003;
        h$ ^= this.linkId.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterLinkId.hashCode();
        h$ *= 1000003;
        h$ ^= this.linkMode.hashCode();
        h$ *= 1000003;
        h$ ^= this.topics.hashCode();
        h$ *= 1000003;
        h$ ^= this.linkError.hashCode();
        h$ *= 1000003;
        h$ ^= this.linkErrorMessage.hashCode();
        h$ *= 1000003;
        h$ ^= this.linkState.hashCode();
        h$ *= 1000003;
        h$ ^= this.tasks.hashCode();
        h$ *= 1000003;
        h$ ^= this.remoteLinkState.hashCode();
        h$ *= 1000003;
        return h$ ^= this.categoryCounts == null ? 0 : this.categoryCounts.hashCode();
    }

    static final class Builder
    extends Link.Builder {
        private String remoteClusterId;
        private String linkName;
        private UUID linkId;
        private Uuid clusterLinkId;
        private ClusterLinkDescription.LinkMode linkMode;
        private ImmutableList<String> topics;
        private ClusterLinkError linkError;
        private String linkErrorMessage;
        private ClusterLinkDescription.LinkState linkState;
        private ImmutableList<ClusterLinkTaskDescription> tasks;
        private ClusterLinkDescription.LinkState remoteLinkState;
        private Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> categoryCounts;

        Builder() {
        }

        @Override
        public Link.Builder setRemoteClusterId(String remoteClusterId) {
            if (remoteClusterId == null) {
                throw new NullPointerException("Null remoteClusterId");
            }
            this.remoteClusterId = remoteClusterId;
            return this;
        }

        @Override
        public Link.Builder setLinkName(String linkName) {
            if (linkName == null) {
                throw new NullPointerException("Null linkName");
            }
            this.linkName = linkName;
            return this;
        }

        @Override
        public Link.Builder setLinkId(UUID linkId) {
            if (linkId == null) {
                throw new NullPointerException("Null linkId");
            }
            this.linkId = linkId;
            return this;
        }

        @Override
        public Link.Builder setClusterLinkId(Uuid clusterLinkId) {
            if (clusterLinkId == null) {
                throw new NullPointerException("Null clusterLinkId");
            }
            this.clusterLinkId = clusterLinkId;
            return this;
        }

        @Override
        public Link.Builder setLinkMode(ClusterLinkDescription.LinkMode linkMode) {
            if (linkMode == null) {
                throw new NullPointerException("Null linkMode");
            }
            this.linkMode = linkMode;
            return this;
        }

        @Override
        public Link.Builder setTopics(ImmutableList<String> topics) {
            if (topics == null) {
                throw new NullPointerException("Null topics");
            }
            this.topics = topics;
            return this;
        }

        @Override
        public Link.Builder setLinkError(ClusterLinkError linkError) {
            if (linkError == null) {
                throw new NullPointerException("Null linkError");
            }
            this.linkError = linkError;
            return this;
        }

        @Override
        public Link.Builder setLinkErrorMessage(String linkErrorMessage) {
            if (linkErrorMessage == null) {
                throw new NullPointerException("Null linkErrorMessage");
            }
            this.linkErrorMessage = linkErrorMessage;
            return this;
        }

        @Override
        public Link.Builder setLinkState(ClusterLinkDescription.LinkState linkState) {
            if (linkState == null) {
                throw new NullPointerException("Null linkState");
            }
            this.linkState = linkState;
            return this;
        }

        @Override
        public Link.Builder setTasks(ImmutableList<ClusterLinkTaskDescription> tasks) {
            if (tasks == null) {
                throw new NullPointerException("Null tasks");
            }
            this.tasks = tasks;
            return this;
        }

        @Override
        public Link.Builder setRemoteLinkState(ClusterLinkDescription.LinkState remoteLinkState) {
            if (remoteLinkState == null) {
                throw new NullPointerException("Null remoteLinkState");
            }
            this.remoteLinkState = remoteLinkState;
            return this;
        }

        @Override
        public Link.Builder setCategoryCounts(Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> categoryCounts) {
            this.categoryCounts = categoryCounts;
            return this;
        }

        @Override
        public Link build() {
            Object missing = "";
            if (this.remoteClusterId == null) {
                missing = (String)missing + " remoteClusterId";
            }
            if (this.linkName == null) {
                missing = (String)missing + " linkName";
            }
            if (this.linkId == null) {
                missing = (String)missing + " linkId";
            }
            if (this.clusterLinkId == null) {
                missing = (String)missing + " clusterLinkId";
            }
            if (this.linkMode == null) {
                missing = (String)missing + " linkMode";
            }
            if (this.topics == null) {
                missing = (String)missing + " topics";
            }
            if (this.linkError == null) {
                missing = (String)missing + " linkError";
            }
            if (this.linkErrorMessage == null) {
                missing = (String)missing + " linkErrorMessage";
            }
            if (this.linkState == null) {
                missing = (String)missing + " linkState";
            }
            if (this.tasks == null) {
                missing = (String)missing + " tasks";
            }
            if (this.remoteLinkState == null) {
                missing = (String)missing + " remoteLinkState";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_Link(this.remoteClusterId, this.linkName, this.linkId, this.clusterLinkId, this.linkMode, this.topics, this.linkError, this.linkErrorMessage, this.linkState, this.tasks, this.remoteLinkState, this.categoryCounts);
        }
    }
}

