/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import io.confluent.kafkarest.entities.ReplicaStatus;
import jakarta.annotation.Nullable;
import java.util.Optional;

final class AutoValue_ReplicaStatus
extends ReplicaStatus {
    private final String clusterId;
    private final String topicName;
    private final int brokerId;
    private final int partitionId;
    private final boolean leader;
    private final boolean observer;
    private final boolean isrEligible;
    private final boolean inIsr;
    private final boolean caughtUp;
    private final long logStartOffset;
    private final long logEndOffset;
    private final long lastCaughtUpTimeMs;
    private final long lastFetchTimeMs;
    private final Optional<String> linkName;

    private AutoValue_ReplicaStatus(String clusterId, String topicName, int brokerId, int partitionId, boolean leader, boolean observer, boolean isrEligible, boolean inIsr, boolean caughtUp, long logStartOffset, long logEndOffset, long lastCaughtUpTimeMs, long lastFetchTimeMs, Optional<String> linkName) {
        this.clusterId = clusterId;
        this.topicName = topicName;
        this.brokerId = brokerId;
        this.partitionId = partitionId;
        this.leader = leader;
        this.observer = observer;
        this.isrEligible = isrEligible;
        this.inIsr = inIsr;
        this.caughtUp = caughtUp;
        this.logStartOffset = logStartOffset;
        this.logEndOffset = logEndOffset;
        this.lastCaughtUpTimeMs = lastCaughtUpTimeMs;
        this.lastFetchTimeMs = lastFetchTimeMs;
        this.linkName = linkName;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    public int getBrokerId() {
        return this.brokerId;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isLeader() {
        return this.leader;
    }

    @Override
    public boolean isObserver() {
        return this.observer;
    }

    @Override
    public boolean isIsrEligible() {
        return this.isrEligible;
    }

    @Override
    public boolean isInIsr() {
        return this.inIsr;
    }

    @Override
    public boolean isCaughtUp() {
        return this.caughtUp;
    }

    @Override
    public long getLogStartOffset() {
        return this.logStartOffset;
    }

    @Override
    public long getLogEndOffset() {
        return this.logEndOffset;
    }

    @Override
    public long getLastCaughtUpTimeMs() {
        return this.lastCaughtUpTimeMs;
    }

    @Override
    public long getLastFetchTimeMs() {
        return this.lastFetchTimeMs;
    }

    @Override
    public Optional<String> getLinkName() {
        return this.linkName;
    }

    public String toString() {
        return "ReplicaStatus{clusterId=" + this.clusterId + ", topicName=" + this.topicName + ", brokerId=" + this.brokerId + ", partitionId=" + this.partitionId + ", leader=" + this.leader + ", observer=" + this.observer + ", isrEligible=" + this.isrEligible + ", inIsr=" + this.inIsr + ", caughtUp=" + this.caughtUp + ", logStartOffset=" + this.logStartOffset + ", logEndOffset=" + this.logEndOffset + ", lastCaughtUpTimeMs=" + this.lastCaughtUpTimeMs + ", lastFetchTimeMs=" + this.lastFetchTimeMs + ", linkName=" + String.valueOf(this.linkName) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReplicaStatus) {
            ReplicaStatus that = (ReplicaStatus)o;
            return this.clusterId.equals(that.getClusterId()) && this.topicName.equals(that.getTopicName()) && this.brokerId == that.getBrokerId() && this.partitionId == that.getPartitionId() && this.leader == that.isLeader() && this.observer == that.isObserver() && this.isrEligible == that.isIsrEligible() && this.inIsr == that.isInIsr() && this.caughtUp == that.isCaughtUp() && this.logStartOffset == that.getLogStartOffset() && this.logEndOffset == that.getLogEndOffset() && this.lastCaughtUpTimeMs == that.getLastCaughtUpTimeMs() && this.lastFetchTimeMs == that.getLastFetchTimeMs() && this.linkName.equals(that.getLinkName());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerId;
        h$ *= 1000003;
        h$ ^= this.partitionId;
        h$ *= 1000003;
        h$ ^= this.leader ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.observer ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.isrEligible ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.inIsr ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.caughtUp ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.logStartOffset >>> 32 ^ this.logStartOffset);
        h$ *= 1000003;
        h$ ^= (int)(this.logEndOffset >>> 32 ^ this.logEndOffset);
        h$ *= 1000003;
        h$ ^= (int)(this.lastCaughtUpTimeMs >>> 32 ^ this.lastCaughtUpTimeMs);
        h$ *= 1000003;
        h$ ^= (int)(this.lastFetchTimeMs >>> 32 ^ this.lastFetchTimeMs);
        h$ *= 1000003;
        return h$ ^= this.linkName.hashCode();
    }

    static final class Builder
    extends ReplicaStatus.Builder {
        private String clusterId;
        private String topicName;
        private Integer brokerId;
        private Integer partitionId;
        private Boolean leader;
        private Boolean observer;
        private Boolean isrEligible;
        private Boolean inIsr;
        private Boolean caughtUp;
        private Long logStartOffset;
        private Long logEndOffset;
        private Long lastCaughtUpTimeMs;
        private Long lastFetchTimeMs;
        private Optional<String> linkName = Optional.empty();

        Builder() {
        }

        @Override
        public ReplicaStatus.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setBrokerId(int brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setLeader(boolean leader) {
            this.leader = leader;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setObserver(boolean observer) {
            this.observer = observer;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setIsrEligible(boolean isrEligible) {
            this.isrEligible = isrEligible;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setInIsr(boolean inIsr) {
            this.inIsr = inIsr;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setCaughtUp(boolean caughtUp) {
            this.caughtUp = caughtUp;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setLogStartOffset(long logStartOffset) {
            this.logStartOffset = logStartOffset;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setLogEndOffset(long logEndOffset) {
            this.logEndOffset = logEndOffset;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setLastCaughtUpTimeMs(long lastCaughtUpTimeMs) {
            this.lastCaughtUpTimeMs = lastCaughtUpTimeMs;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setLastFetchTimeMs(long lastFetchTimeMs) {
            this.lastFetchTimeMs = lastFetchTimeMs;
            return this;
        }

        @Override
        public ReplicaStatus.Builder setLinkName(@Nullable String linkName) {
            this.linkName = Optional.ofNullable(linkName);
            return this;
        }

        @Override
        public ReplicaStatus build() {
            Object missing = "";
            if (this.clusterId == null) {
                missing = (String)missing + " clusterId";
            }
            if (this.topicName == null) {
                missing = (String)missing + " topicName";
            }
            if (this.brokerId == null) {
                missing = (String)missing + " brokerId";
            }
            if (this.partitionId == null) {
                missing = (String)missing + " partitionId";
            }
            if (this.leader == null) {
                missing = (String)missing + " leader";
            }
            if (this.observer == null) {
                missing = (String)missing + " observer";
            }
            if (this.isrEligible == null) {
                missing = (String)missing + " isrEligible";
            }
            if (this.inIsr == null) {
                missing = (String)missing + " inIsr";
            }
            if (this.caughtUp == null) {
                missing = (String)missing + " caughtUp";
            }
            if (this.logStartOffset == null) {
                missing = (String)missing + " logStartOffset";
            }
            if (this.logEndOffset == null) {
                missing = (String)missing + " logEndOffset";
            }
            if (this.lastCaughtUpTimeMs == null) {
                missing = (String)missing + " lastCaughtUpTimeMs";
            }
            if (this.lastFetchTimeMs == null) {
                missing = (String)missing + " lastFetchTimeMs";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_ReplicaStatus(this.clusterId, this.topicName, this.brokerId, this.partitionId, this.leader, this.observer, this.isrEligible, this.inIsr, this.caughtUp, this.logStartOffset, this.logEndOffset, this.lastCaughtUpTimeMs, this.lastFetchTimeMs, this.linkName);
        }
    }
}

