/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.kafkarest.entities.AutoValue_Link;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskDescription;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.replica.ReplicaStatus;

@AutoValue
public abstract class Link {
    Link() {
    }

    public abstract String getRemoteClusterId();

    public abstract String getLinkName();

    public abstract UUID getLinkId();

    public abstract Uuid getClusterLinkId();

    public abstract ClusterLinkDescription.LinkMode getLinkMode();

    public abstract ImmutableList<String> getTopics();

    public abstract ClusterLinkError getLinkError();

    public abstract String getLinkErrorMessage();

    public abstract ClusterLinkDescription.LinkState getLinkState();

    public abstract ImmutableList<ClusterLinkTaskDescription> getTasks();

    public abstract ClusterLinkDescription.LinkState getRemoteLinkState();

    @Nullable
    public abstract Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> getCategoryCounts();

    public static Link create(String linkName, String remoteClusterId, Uuid clusterLinkId, ClusterLinkDescription.LinkMode linkMode, ImmutableList<String> topics, ClusterLinkError linkError, String linkErrorMessage, ClusterLinkDescription.LinkState linkState, ImmutableList<ClusterLinkTaskDescription> tasks, ClusterLinkDescription.LinkState remoteLinkState) {
        return Link.builder().setRemoteClusterId(remoteClusterId).setLinkName(linkName).setClusterLinkId(clusterLinkId).setLinkId(new UUID(clusterLinkId.getMostSignificantBits(), clusterLinkId.getLeastSignificantBits())).setLinkMode(linkMode).setTopics(topics).setLinkError(linkError).setLinkErrorMessage(linkErrorMessage).setLinkState(linkState).setTasks(tasks).setRemoteLinkState(remoteLinkState).setCategoryCounts((Map<ReplicaStatus.MirrorInfo.StateCategory, Integer>)ImmutableMap.of()).build();
    }

    public static Link fromClusterLinkDescription(ClusterLinkDescription description) {
        return Link.builder().setRemoteClusterId(description.remoteClusterId() != null ? description.remoteClusterId() : "").setLinkName(description.linkName()).setClusterLinkId(description.clusterLinkId()).setLinkId(new UUID(description.clusterLinkId().getMostSignificantBits(), description.clusterLinkId().getLeastSignificantBits())).setLinkMode(description.linkMode() != null ? description.linkMode() : ClusterLinkDescription.LinkMode.UNKNOWN).setTopics((ImmutableList<String>)description.topics().map(topics -> (ImmutableList)topics.stream().collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of())).setLinkError(description.clusterLinkError() != null ? description.clusterLinkError() : ClusterLinkError.UNKNOWN).setLinkErrorMessage(description.linkErrorMessage() != null ? description.linkErrorMessage() : "").setLinkState(description.linkState() != null ? description.linkState() : ClusterLinkDescription.LinkState.UNKNOWN).setRemoteLinkState(description.remoteLinkState() != null ? description.remoteLinkState() : ClusterLinkDescription.LinkState.UNKNOWN).setTasks((ImmutableList<ClusterLinkTaskDescription>)((ImmutableList)description.taskDescriptions().stream().collect(ImmutableList.toImmutableList()))).setCategoryCounts(description.partitionStateCategoryCounts()).build();
    }

    public static Builder builder() {
        return new AutoValue_Link.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Link build();

        public abstract Builder setRemoteClusterId(String var1);

        public abstract Builder setLinkName(String var1);

        public abstract Builder setClusterLinkId(Uuid var1);

        public abstract Builder setLinkId(UUID var1);

        public abstract Builder setLinkMode(ClusterLinkDescription.LinkMode var1);

        public abstract Builder setTopics(ImmutableList<String> var1);

        public abstract Builder setLinkError(ClusterLinkError var1);

        public abstract Builder setLinkErrorMessage(String var1);

        public abstract Builder setLinkState(ClusterLinkDescription.LinkState var1);

        public abstract Builder setTasks(ImmutableList<ClusterLinkTaskDescription> var1);

        public abstract Builder setRemoteLinkState(ClusterLinkDescription.LinkState var1);

        public abstract Builder setCategoryCounts(Map<ReplicaStatus.MirrorInfo.StateCategory, Integer> var1);
    }
}

