/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import jakarta.ws.rs.BadRequestException;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.MirrorTopicDescription;

public enum MirrorStatus {
    ACTIVE(MirrorTopicDescription.State.ACTIVE),
    FAILED(MirrorTopicDescription.State.FAILED),
    PAUSED(MirrorTopicDescription.State.PAUSED),
    STOPPED(MirrorTopicDescription.State.STOPPED),
    PENDING_STOPPED(MirrorTopicDescription.State.PENDING_STOPPED),
    PENDING_SYNCHRONIZE(MirrorTopicDescription.State.PENDING_SYNCHRONIZE),
    PENDING_MIRROR(MirrorTopicDescription.State.PENDING_MIRROR),
    PENDING_REPAIR(MirrorTopicDescription.State.PENDING_REPAIR),
    PENDING_RESTORE(MirrorTopicDescription.State.PENDING_RESTORE),
    PENDING_SETUP_FOR_RESTORE(MirrorTopicDescription.State.PENDING_SETUP_FOR_RESTORE),
    SOURCE_UNAVAILABLE(MirrorTopicDescription.State.SOURCE_UNAVAILABLE),
    LINK_FAILED(MirrorTopicDescription.State.LINK_FAILED),
    LINK_PAUSED(MirrorTopicDescription.State.LINK_PAUSED),
    UNKNOWN(MirrorTopicDescription.State.UNKNOWN);

    private MirrorTopicDescription.State state;
    private static Set<String> VALID_NAMES;

    private MirrorStatus(MirrorTopicDescription.State state) {
        this.state = state;
    }

    public static MirrorStatus fromString(String name) {
        if (name == null) {
            return null;
        }
        String upper = name.toUpperCase();
        if (!VALID_NAMES.contains(upper)) {
            throw new BadRequestException("Unexpected mirror status: " + upper + ". valid status are: " + String.valueOf(VALID_NAMES));
        }
        return MirrorStatus.valueOf(upper);
    }

    public MirrorTopicDescription.State getState() {
        return this.state;
    }

    static {
        VALID_NAMES = Arrays.stream(MirrorStatus.values()).map(Enum::name).collect(Collectors.toSet());
    }
}

