/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.AlterBrokerReplicaExclusion;
import io.confluent.kafkarest.entities.v3.AutoValue_AlterBrokerReplicaExclusionData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.apache.kafka.clients.admin.ExclusionOp;

@AutoValue
public abstract class AlterBrokerReplicaExclusionData
extends Resource {
    AlterBrokerReplicaExclusionData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="broker_id")
    public abstract int getBrokerId();

    @JsonProperty(value="exclusion")
    public abstract ExclusionOp.OpType getExclusion();

    @JsonProperty(value="reason")
    public abstract String getReason();

    @JsonProperty(value="error_code")
    public abstract Optional<Short> getErrorCode();

    @JsonProperty(value="error_message")
    public abstract Optional<String> getErrorMessage();

    @JsonProperty(value="broker")
    public abstract Resource.Relationship getBroker();

    public static Builder builder() {
        return new AutoValue_AlterBrokerReplicaExclusionData.Builder().setKind("KafkaAlterBrokerReplicaExclusion");
    }

    public static Builder fromAlterBrokerReplicaExclusion(AlterBrokerReplicaExclusion alterBrokerReplicaExclusion) {
        return AlterBrokerReplicaExclusionData.builder().setClusterId(alterBrokerReplicaExclusion.getClusterId()).setBrokerId(alterBrokerReplicaExclusion.getBrokerId()).setExclusion(alterBrokerReplicaExclusion.getExclusion()).setReason(alterBrokerReplicaExclusion.getReason()).setErrorCode(alterBrokerReplicaExclusion.getErrorCode().orElse(null)).setErrorMessage(alterBrokerReplicaExclusion.getErrorMessage().orElse(null));
    }

    @JsonCreator
    static AlterBrokerReplicaExclusionData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="broker_id") int brokerId, @JsonProperty(value="exclusion") ExclusionOp.OpType exclusion, @JsonProperty(value="reason") String reason, @JsonProperty(value="error_code") @Nullable Short errorCode, @JsonProperty(value="error_message") @Nullable String errorMessage, @JsonProperty(value="broker") Resource.Relationship broker) {
        return ((Builder)((Builder)AlterBrokerReplicaExclusionData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setBrokerId(brokerId).setExclusion(exclusion).setReason(reason).setErrorCode(errorCode).setErrorMessage(errorMessage).setBroker(broker).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setBrokerId(int var1);

        public abstract Builder setExclusion(ExclusionOp.OpType var1);

        public abstract Builder setReason(String var1);

        public abstract Builder setErrorCode(@Nullable Short var1);

        public abstract Builder setErrorMessage(@Nullable String var1);

        public abstract Builder setBroker(Resource.Relationship var1);

        public abstract AlterBrokerReplicaExclusionData build();
    }
}

