/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.BalancerAnyUnevenLoadStatusData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Optional;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;

final class AutoValue_BalancerAnyUnevenLoadStatusData
extends BalancerAnyUnevenLoadStatusData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final EvenClusterLoadStatus status;
    private final Optional<EvenClusterLoadStatus> previousStatus;
    private final Optional<Instant> statusUpdatedAt;
    private final Optional<Instant> previousStatusUpdatedAt;
    private final Optional<Short> errorCode;
    private final Optional<String> errorMessage;
    private final Resource.Relationship brokerTasks;

    private AutoValue_BalancerAnyUnevenLoadStatusData(String kind, Resource.Metadata metadata, String clusterId, EvenClusterLoadStatus status, Optional<EvenClusterLoadStatus> previousStatus, Optional<Instant> statusUpdatedAt, Optional<Instant> previousStatusUpdatedAt, Optional<Short> errorCode, Optional<String> errorMessage, Resource.Relationship brokerTasks) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.status = status;
        this.previousStatus = previousStatus;
        this.statusUpdatedAt = statusUpdatedAt;
        this.previousStatusUpdatedAt = previousStatusUpdatedAt;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.brokerTasks = brokerTasks;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="status")
    public EvenClusterLoadStatus getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty(value="previous_status")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<EvenClusterLoadStatus> getPreviousStatus() {
        return this.previousStatus;
    }

    @Override
    @JsonProperty(value="status_updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<Instant> getStatusUpdatedAt() {
        return this.statusUpdatedAt;
    }

    @Override
    @JsonProperty(value="previous_status_updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<Instant> getPreviousStatusUpdatedAt() {
        return this.previousStatusUpdatedAt;
    }

    @Override
    @JsonProperty(value="error_code")
    public Optional<Short> getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="error_message")
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonProperty(value="broker_tasks")
    public Resource.Relationship getBrokerTasks() {
        return this.brokerTasks;
    }

    public String toString() {
        return "BalancerAnyUnevenLoadStatusData{kind=" + this.kind + ", metadata=" + String.valueOf(this.metadata) + ", clusterId=" + this.clusterId + ", status=" + String.valueOf(this.status) + ", previousStatus=" + String.valueOf(this.previousStatus) + ", statusUpdatedAt=" + String.valueOf(this.statusUpdatedAt) + ", previousStatusUpdatedAt=" + String.valueOf(this.previousStatusUpdatedAt) + ", errorCode=" + String.valueOf(this.errorCode) + ", errorMessage=" + String.valueOf(this.errorMessage) + ", brokerTasks=" + String.valueOf(this.brokerTasks) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BalancerAnyUnevenLoadStatusData) {
            BalancerAnyUnevenLoadStatusData that = (BalancerAnyUnevenLoadStatusData)((Object)o);
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.status.equals((Object)that.getStatus()) && this.previousStatus.equals(that.getPreviousStatus()) && this.statusUpdatedAt.equals(that.getStatusUpdatedAt()) && this.previousStatusUpdatedAt.equals(that.getPreviousStatusUpdatedAt()) && this.errorCode.equals(that.getErrorCode()) && this.errorMessage.equals(that.getErrorMessage()) && this.brokerTasks.equals(that.getBrokerTasks());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.status.hashCode();
        h$ *= 1000003;
        h$ ^= this.previousStatus.hashCode();
        h$ *= 1000003;
        h$ ^= this.statusUpdatedAt.hashCode();
        h$ *= 1000003;
        h$ ^= this.previousStatusUpdatedAt.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorCode.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorMessage.hashCode();
        h$ *= 1000003;
        return h$ ^= this.brokerTasks.hashCode();
    }

    static final class Builder
    extends BalancerAnyUnevenLoadStatusData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private EvenClusterLoadStatus status;
        private Optional<EvenClusterLoadStatus> previousStatus = Optional.empty();
        private Optional<Instant> statusUpdatedAt = Optional.empty();
        private Optional<Instant> previousStatusUpdatedAt = Optional.empty();
        private Optional<Short> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();
        private Resource.Relationship brokerTasks;

        Builder() {
        }

        public BalancerAnyUnevenLoadStatusData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        public BalancerAnyUnevenLoadStatusData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatusData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatusData.Builder setStatus(EvenClusterLoadStatus status) {
            if (status == null) {
                throw new NullPointerException("Null status");
            }
            this.status = status;
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatusData.Builder setPreviousStatus(@Nullable EvenClusterLoadStatus previousStatus) {
            this.previousStatus = Optional.ofNullable(previousStatus);
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatusData.Builder setStatusUpdatedAt(@Nullable Instant statusUpdatedAt) {
            this.statusUpdatedAt = Optional.ofNullable(statusUpdatedAt);
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatusData.Builder setPreviousStatusUpdatedAt(@Nullable Instant previousStatusUpdatedAt) {
            this.previousStatusUpdatedAt = Optional.ofNullable(previousStatusUpdatedAt);
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatusData.Builder setErrorCode(@Nullable Short errorCode) {
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatusData.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatusData.Builder setBrokerTasks(Resource.Relationship brokerTasks) {
            if (brokerTasks == null) {
                throw new NullPointerException("Null brokerTasks");
            }
            this.brokerTasks = brokerTasks;
            return this;
        }

        @Override
        public BalancerAnyUnevenLoadStatusData build() {
            Object missing = "";
            if (this.kind == null) {
                missing = (String)missing + " kind";
            }
            if (this.metadata == null) {
                missing = (String)missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = (String)missing + " clusterId";
            }
            if (this.status == null) {
                missing = (String)missing + " status";
            }
            if (this.brokerTasks == null) {
                missing = (String)missing + " brokerTasks";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_BalancerAnyUnevenLoadStatusData(this.kind, this.metadata, this.clusterId, this.status, this.previousStatus, this.statusUpdatedAt, this.previousStatusUpdatedAt, this.errorCode, this.errorMessage, this.brokerTasks);
        }
    }
}

