/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.BrokerTaskType;
import io.confluent.kafkarest.entities.v3.BrokerSubTaskStatusesData;
import io.confluent.kafkarest.entities.v3.BrokerTaskData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Optional;
import org.apache.kafka.clients.admin.BalancerOperationStatus;

final class AutoValue_BrokerTaskData
extends BrokerTaskData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final int brokerId;
    private final BrokerTaskType taskType;
    private final Optional<Boolean> shutdownScheduled;
    private final BalancerOperationStatus brokerTaskStatus;
    private final BrokerSubTaskStatusesData brokerSubTaskStatuses;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Optional<Short> errorCode;
    private final Optional<String> errorMessage;
    private final Resource.Relationship broker;

    private AutoValue_BrokerTaskData(String kind, Resource.Metadata metadata, String clusterId, int brokerId, BrokerTaskType taskType, Optional<Boolean> shutdownScheduled, BalancerOperationStatus brokerTaskStatus, BrokerSubTaskStatusesData brokerSubTaskStatuses, Instant createdAt, Instant updatedAt, Optional<Short> errorCode, Optional<String> errorMessage, Resource.Relationship broker) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.taskType = taskType;
        this.shutdownScheduled = shutdownScheduled;
        this.brokerTaskStatus = brokerTaskStatus;
        this.brokerSubTaskStatuses = brokerSubTaskStatuses;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.broker = broker;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="broker_id")
    public int getBrokerId() {
        return this.brokerId;
    }

    @Override
    @JsonProperty(value="task_type")
    public BrokerTaskType getTaskType() {
        return this.taskType;
    }

    @Override
    @JsonProperty(value="shutdown_scheduled")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<Boolean> getShutdownScheduled() {
        return this.shutdownScheduled;
    }

    @Override
    @JsonProperty(value="task_status")
    public BalancerOperationStatus getBrokerTaskStatus() {
        return this.brokerTaskStatus;
    }

    @Override
    @JsonProperty(value="sub_task_statuses")
    public BrokerSubTaskStatusesData getBrokerSubTaskStatuses() {
        return this.brokerSubTaskStatuses;
    }

    @Override
    @JsonProperty(value="created_at")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="updated_at")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="error_code")
    public Optional<Short> getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="error_message")
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonProperty(value="broker")
    public Resource.Relationship getBroker() {
        return this.broker;
    }

    public String toString() {
        return "BrokerTaskData{kind=" + this.kind + ", metadata=" + String.valueOf(this.metadata) + ", clusterId=" + this.clusterId + ", brokerId=" + this.brokerId + ", taskType=" + String.valueOf((Object)this.taskType) + ", shutdownScheduled=" + String.valueOf(this.shutdownScheduled) + ", brokerTaskStatus=" + String.valueOf(this.brokerTaskStatus) + ", brokerSubTaskStatuses=" + String.valueOf(this.brokerSubTaskStatuses) + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", errorCode=" + String.valueOf(this.errorCode) + ", errorMessage=" + String.valueOf(this.errorMessage) + ", broker=" + String.valueOf(this.broker) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BrokerTaskData) {
            BrokerTaskData that = (BrokerTaskData)((Object)o);
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.brokerId == that.getBrokerId() && this.taskType.equals((Object)that.getTaskType()) && this.shutdownScheduled.equals(that.getShutdownScheduled()) && this.brokerTaskStatus.equals((Object)that.getBrokerTaskStatus()) && this.brokerSubTaskStatuses.equals(that.getBrokerSubTaskStatuses()) && this.createdAt.equals(that.getCreatedAt()) && this.updatedAt.equals(that.getUpdatedAt()) && this.errorCode.equals(that.getErrorCode()) && this.errorMessage.equals(that.getErrorMessage()) && this.broker.equals(that.getBroker());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerId;
        h$ *= 1000003;
        h$ ^= this.taskType.hashCode();
        h$ *= 1000003;
        h$ ^= this.shutdownScheduled.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerTaskStatus.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerSubTaskStatuses.hashCode();
        h$ *= 1000003;
        h$ ^= this.createdAt.hashCode();
        h$ *= 1000003;
        h$ ^= this.updatedAt.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorCode.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorMessage.hashCode();
        h$ *= 1000003;
        return h$ ^= this.broker.hashCode();
    }

    static final class Builder
    extends BrokerTaskData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private Integer brokerId;
        private BrokerTaskType taskType;
        private Optional<Boolean> shutdownScheduled = Optional.empty();
        private BalancerOperationStatus brokerTaskStatus;
        private BrokerSubTaskStatusesData brokerSubTaskStatuses;
        private Instant createdAt;
        private Instant updatedAt;
        private Optional<Short> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();
        private Resource.Relationship broker;

        Builder() {
        }

        public BrokerTaskData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        public BrokerTaskData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public BrokerTaskData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public BrokerTaskData.Builder setBrokerId(int brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        @Override
        public BrokerTaskData.Builder setTaskType(BrokerTaskType taskType) {
            if (taskType == null) {
                throw new NullPointerException("Null taskType");
            }
            this.taskType = taskType;
            return this;
        }

        @Override
        public BrokerTaskData.Builder setShutdownScheduled(@Nullable Boolean shutdownScheduled) {
            this.shutdownScheduled = Optional.ofNullable(shutdownScheduled);
            return this;
        }

        @Override
        public BrokerTaskData.Builder setBrokerTaskStatus(BalancerOperationStatus brokerTaskStatus) {
            if (brokerTaskStatus == null) {
                throw new NullPointerException("Null brokerTaskStatus");
            }
            this.brokerTaskStatus = brokerTaskStatus;
            return this;
        }

        @Override
        public BrokerTaskData.Builder setBrokerSubTaskStatuses(BrokerSubTaskStatusesData brokerSubTaskStatuses) {
            if (brokerSubTaskStatuses == null) {
                throw new NullPointerException("Null brokerSubTaskStatuses");
            }
            this.brokerSubTaskStatuses = brokerSubTaskStatuses;
            return this;
        }

        @Override
        public BrokerTaskData.Builder setCreatedAt(Instant createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("Null createdAt");
            }
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public BrokerTaskData.Builder setUpdatedAt(Instant updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("Null updatedAt");
            }
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public BrokerTaskData.Builder setErrorCode(@Nullable Short errorCode) {
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        @Override
        public BrokerTaskData.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        public BrokerTaskData.Builder setBroker(Resource.Relationship broker) {
            if (broker == null) {
                throw new NullPointerException("Null broker");
            }
            this.broker = broker;
            return this;
        }

        @Override
        public BrokerTaskData build() {
            Object missing = "";
            if (this.kind == null) {
                missing = (String)missing + " kind";
            }
            if (this.metadata == null) {
                missing = (String)missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = (String)missing + " clusterId";
            }
            if (this.brokerId == null) {
                missing = (String)missing + " brokerId";
            }
            if (this.taskType == null) {
                missing = (String)missing + " taskType";
            }
            if (this.brokerTaskStatus == null) {
                missing = (String)missing + " brokerTaskStatus";
            }
            if (this.brokerSubTaskStatuses == null) {
                missing = (String)missing + " brokerSubTaskStatuses";
            }
            if (this.createdAt == null) {
                missing = (String)missing + " createdAt";
            }
            if (this.updatedAt == null) {
                missing = (String)missing + " updatedAt";
            }
            if (this.broker == null) {
                missing = (String)missing + " broker";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_BrokerTaskData(this.kind, this.metadata, this.clusterId, this.brokerId, this.taskType, this.shutdownScheduled, this.brokerTaskStatus, this.brokerSubTaskStatuses, this.createdAt, this.updatedAt, this.errorCode, this.errorMessage, this.broker);
        }
    }
}

