/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.CellData;
import io.confluent.kafkarest.entities.v3.CellStateData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;

final class AutoValue_CellStateData
extends CellStateData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final List<CellData> cells;
    private final Boolean cellsEnabled;
    private final Optional<Short> errorCode;
    private final Optional<String> errorMessage;

    private AutoValue_CellStateData(String kind, Resource.Metadata metadata, String clusterId, List<CellData> cells, Boolean cellsEnabled, Optional<Short> errorCode, Optional<String> errorMessage) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.cells = cells;
        this.cellsEnabled = cellsEnabled;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="cells")
    public List<CellData> getCells() {
        return this.cells;
    }

    @Override
    @JsonProperty(value="cells_enabled")
    public Boolean getCellsEnabled() {
        return this.cellsEnabled;
    }

    @Override
    @JsonProperty(value="error_code")
    public Optional<Short> getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="error_message")
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return "CellStateData{kind=" + this.kind + ", metadata=" + String.valueOf(this.metadata) + ", clusterId=" + this.clusterId + ", cells=" + String.valueOf(this.cells) + ", cellsEnabled=" + this.cellsEnabled + ", errorCode=" + String.valueOf(this.errorCode) + ", errorMessage=" + String.valueOf(this.errorMessage) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CellStateData) {
            CellStateData that = (CellStateData)((Object)o);
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.cells.equals(that.getCells()) && this.cellsEnabled.equals(that.getCellsEnabled()) && this.errorCode.equals(that.getErrorCode()) && this.errorMessage.equals(that.getErrorMessage());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.cells.hashCode();
        h$ *= 1000003;
        h$ ^= this.cellsEnabled.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorCode.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorMessage.hashCode();
    }

    static final class Builder
    extends CellStateData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private List<CellData> cells;
        private Boolean cellsEnabled;
        private Optional<Short> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();

        Builder() {
        }

        public CellStateData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        public CellStateData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public CellStateData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public CellStateData.Builder setCells(List<CellData> cells) {
            if (cells == null) {
                throw new NullPointerException("Null cells");
            }
            this.cells = cells;
            return this;
        }

        @Override
        public CellStateData.Builder setCellsEnabled(Boolean cellsEnabled) {
            if (cellsEnabled == null) {
                throw new NullPointerException("Null cellsEnabled");
            }
            this.cellsEnabled = cellsEnabled;
            return this;
        }

        @Override
        public CellStateData.Builder setErrorCode(@Nullable Short errorCode) {
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        @Override
        public CellStateData.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        public CellStateData build() {
            Object missing = "";
            if (this.kind == null) {
                missing = (String)missing + " kind";
            }
            if (this.metadata == null) {
                missing = (String)missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = (String)missing + " clusterId";
            }
            if (this.cells == null) {
                missing = (String)missing + " cells";
            }
            if (this.cellsEnabled == null) {
                missing = (String)missing + " cellsEnabled";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_CellStateData(this.kind, this.metadata, this.clusterId, this.cells, this.cellsEnabled, this.errorCode, this.errorMessage);
        }
    }
}

