/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.CreateLinkRequest;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;

final class AutoValue_CreateLinkRequest
extends CreateLinkRequest {
    private final ImmutableList<CreateLinkRequest.ConfigEntry> configs;
    private final Optional<String> sourceClusterId;
    private final Optional<String> destinationClusterId;
    private final Optional<String> remoteClusterId;
    private final Optional<String> clusterLinkId;

    private AutoValue_CreateLinkRequest(ImmutableList<CreateLinkRequest.ConfigEntry> configs, Optional<String> sourceClusterId, Optional<String> destinationClusterId, Optional<String> remoteClusterId, Optional<String> clusterLinkId) {
        this.configs = configs;
        this.sourceClusterId = sourceClusterId;
        this.destinationClusterId = destinationClusterId;
        this.remoteClusterId = remoteClusterId;
        this.clusterLinkId = clusterLinkId;
    }

    @Override
    @JsonProperty(value="configs")
    public ImmutableList<CreateLinkRequest.ConfigEntry> getConfigs() {
        return this.configs;
    }

    @Override
    @JsonProperty(value="source_cluster_id")
    public Optional<String> getSourceClusterId() {
        return this.sourceClusterId;
    }

    @Override
    @JsonProperty(value="destination_cluster_id")
    public Optional<String> getDestinationClusterId() {
        return this.destinationClusterId;
    }

    @Override
    @JsonProperty(value="remote_cluster_id")
    public Optional<String> getRemoteClusterId() {
        return this.remoteClusterId;
    }

    @Override
    @JsonProperty(value="cluster_link_id")
    public Optional<String> getClusterLinkId() {
        return this.clusterLinkId;
    }

    public String toString() {
        return "CreateLinkRequest{configs=" + String.valueOf(this.configs) + ", sourceClusterId=" + String.valueOf(this.sourceClusterId) + ", destinationClusterId=" + String.valueOf(this.destinationClusterId) + ", remoteClusterId=" + String.valueOf(this.remoteClusterId) + ", clusterLinkId=" + String.valueOf(this.clusterLinkId) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CreateLinkRequest) {
            CreateLinkRequest that = (CreateLinkRequest)o;
            return this.configs.equals(that.getConfigs()) && this.sourceClusterId.equals(that.getSourceClusterId()) && this.destinationClusterId.equals(that.getDestinationClusterId()) && this.remoteClusterId.equals(that.getRemoteClusterId()) && this.clusterLinkId.equals(that.getClusterLinkId());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.configs.hashCode();
        h$ *= 1000003;
        h$ ^= this.sourceClusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.destinationClusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.remoteClusterId.hashCode();
        h$ *= 1000003;
        return h$ ^= this.clusterLinkId.hashCode();
    }

    static final class Builder
    extends CreateLinkRequest.Builder {
        private ImmutableList<CreateLinkRequest.ConfigEntry> configs;
        private Optional<String> sourceClusterId = Optional.empty();
        private Optional<String> destinationClusterId = Optional.empty();
        private Optional<String> remoteClusterId = Optional.empty();
        private Optional<String> clusterLinkId = Optional.empty();

        Builder() {
        }

        @Override
        public CreateLinkRequest.Builder setConfigs(List<CreateLinkRequest.ConfigEntry> configs) {
            this.configs = ImmutableList.copyOf(configs);
            return this;
        }

        @Override
        public CreateLinkRequest.Builder setSourceClusterId(@Nullable String sourceClusterId) {
            this.sourceClusterId = Optional.ofNullable(sourceClusterId);
            return this;
        }

        @Override
        public CreateLinkRequest.Builder setDestinationClusterId(@Nullable String destinationClusterId) {
            this.destinationClusterId = Optional.ofNullable(destinationClusterId);
            return this;
        }

        @Override
        public CreateLinkRequest.Builder setRemoteClusterId(@Nullable String remoteClusterId) {
            this.remoteClusterId = Optional.ofNullable(remoteClusterId);
            return this;
        }

        @Override
        public CreateLinkRequest.Builder setClusterLinkId(@Nullable String clusterLinkId) {
            this.clusterLinkId = Optional.ofNullable(clusterLinkId);
            return this;
        }

        @Override
        public CreateLinkRequest build() {
            Object missing = "";
            if (this.configs == null) {
                missing = (String)missing + " configs";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_CreateLinkRequest(this.configs, this.sourceClusterId, this.destinationClusterId, this.remoteClusterId, this.clusterLinkId);
        }
    }
}

