/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.RemoveBrokerTaskData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.apache.kafka.clients.admin.BrokerReplicaExclusionStatus;
import org.apache.kafka.clients.admin.BrokerShutdownStatus;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;

final class AutoValue_RemoveBrokerTaskData
extends RemoveBrokerTaskData {
    private final String kind;
    private final Resource.Metadata metadata;
    private final String clusterId;
    private final int brokerId;
    private final boolean shutdownScheduled;
    private final BrokerReplicaExclusionStatus brokerReplicaExclusionStatus;
    private final PartitionReassignmentsStatus partitionReassignmentStatus;
    private final BrokerShutdownStatus brokerShutdownStatus;
    private final Optional<Short> errorCode;
    private final Optional<String> errorMessage;
    private final Resource.Relationship broker;

    private AutoValue_RemoveBrokerTaskData(String kind, Resource.Metadata metadata, String clusterId, int brokerId, boolean shutdownScheduled, BrokerReplicaExclusionStatus brokerReplicaExclusionStatus, PartitionReassignmentsStatus partitionReassignmentStatus, BrokerShutdownStatus brokerShutdownStatus, Optional<Short> errorCode, Optional<String> errorMessage, Resource.Relationship broker) {
        this.kind = kind;
        this.metadata = metadata;
        this.clusterId = clusterId;
        this.brokerId = brokerId;
        this.shutdownScheduled = shutdownScheduled;
        this.brokerReplicaExclusionStatus = brokerReplicaExclusionStatus;
        this.partitionReassignmentStatus = partitionReassignmentStatus;
        this.brokerShutdownStatus = brokerShutdownStatus;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.broker = broker;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="metadata")
    public Resource.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="broker_id")
    public int getBrokerId() {
        return this.brokerId;
    }

    @Override
    @JsonProperty(value="shutdown_scheduled")
    public boolean getShutdownScheduled() {
        return this.shutdownScheduled;
    }

    @Override
    @JsonProperty(value="broker_replica_exclusion_status")
    public BrokerReplicaExclusionStatus getBrokerReplicaExclusionStatus() {
        return this.brokerReplicaExclusionStatus;
    }

    @Override
    @JsonProperty(value="partition_reassignment_status")
    public PartitionReassignmentsStatus getPartitionReassignmentStatus() {
        return this.partitionReassignmentStatus;
    }

    @Override
    @JsonProperty(value="broker_shutdown_status")
    public BrokerShutdownStatus getBrokerShutdownStatus() {
        return this.brokerShutdownStatus;
    }

    @Override
    @JsonProperty(value="error_code")
    public Optional<Short> getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="error_message")
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonProperty(value="broker")
    public Resource.Relationship getBroker() {
        return this.broker;
    }

    public String toString() {
        return "RemoveBrokerTaskData{kind=" + this.kind + ", metadata=" + String.valueOf(this.metadata) + ", clusterId=" + this.clusterId + ", brokerId=" + this.brokerId + ", shutdownScheduled=" + this.shutdownScheduled + ", brokerReplicaExclusionStatus=" + String.valueOf(this.brokerReplicaExclusionStatus) + ", partitionReassignmentStatus=" + String.valueOf(this.partitionReassignmentStatus) + ", brokerShutdownStatus=" + String.valueOf(this.brokerShutdownStatus) + ", errorCode=" + String.valueOf(this.errorCode) + ", errorMessage=" + String.valueOf(this.errorMessage) + ", broker=" + String.valueOf(this.broker) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RemoveBrokerTaskData) {
            RemoveBrokerTaskData that = (RemoveBrokerTaskData)((Object)o);
            return this.kind.equals(that.getKind()) && this.metadata.equals(that.getMetadata()) && this.clusterId.equals(that.getClusterId()) && this.brokerId == that.getBrokerId() && this.shutdownScheduled == that.getShutdownScheduled() && this.brokerReplicaExclusionStatus.equals((Object)that.getBrokerReplicaExclusionStatus()) && this.partitionReassignmentStatus.equals((Object)that.getPartitionReassignmentStatus()) && this.brokerShutdownStatus.equals((Object)that.getBrokerShutdownStatus()) && this.errorCode.equals(that.getErrorCode()) && this.errorMessage.equals(that.getErrorMessage()) && this.broker.equals(that.getBroker());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.kind.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadata.hashCode();
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerId;
        h$ *= 1000003;
        h$ ^= this.shutdownScheduled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.brokerReplicaExclusionStatus.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionReassignmentStatus.hashCode();
        h$ *= 1000003;
        h$ ^= this.brokerShutdownStatus.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorCode.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorMessage.hashCode();
        h$ *= 1000003;
        return h$ ^= this.broker.hashCode();
    }

    static final class Builder
    extends RemoveBrokerTaskData.Builder {
        private String kind;
        private Resource.Metadata metadata;
        private String clusterId;
        private Integer brokerId;
        private Boolean shutdownScheduled;
        private BrokerReplicaExclusionStatus brokerReplicaExclusionStatus;
        private PartitionReassignmentsStatus partitionReassignmentStatus;
        private BrokerShutdownStatus brokerShutdownStatus;
        private Optional<Short> errorCode = Optional.empty();
        private Optional<String> errorMessage = Optional.empty();
        private Resource.Relationship broker;

        Builder() {
        }

        public RemoveBrokerTaskData.Builder setKind(String kind) {
            if (kind == null) {
                throw new NullPointerException("Null kind");
            }
            this.kind = kind;
            return this;
        }

        public RemoveBrokerTaskData.Builder setMetadata(Resource.Metadata metadata) {
            if (metadata == null) {
                throw new NullPointerException("Null metadata");
            }
            this.metadata = metadata;
            return this;
        }

        @Override
        public RemoveBrokerTaskData.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public RemoveBrokerTaskData.Builder setBrokerId(int brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        @Override
        public RemoveBrokerTaskData.Builder setShutdownScheduled(boolean shutdownScheduled) {
            this.shutdownScheduled = shutdownScheduled;
            return this;
        }

        @Override
        public RemoveBrokerTaskData.Builder setBrokerReplicaExclusionStatus(BrokerReplicaExclusionStatus brokerReplicaExclusionStatus) {
            if (brokerReplicaExclusionStatus == null) {
                throw new NullPointerException("Null brokerReplicaExclusionStatus");
            }
            this.brokerReplicaExclusionStatus = brokerReplicaExclusionStatus;
            return this;
        }

        @Override
        public RemoveBrokerTaskData.Builder setPartitionReassignmentStatus(PartitionReassignmentsStatus partitionReassignmentStatus) {
            if (partitionReassignmentStatus == null) {
                throw new NullPointerException("Null partitionReassignmentStatus");
            }
            this.partitionReassignmentStatus = partitionReassignmentStatus;
            return this;
        }

        @Override
        public RemoveBrokerTaskData.Builder setBrokerShutdownStatus(BrokerShutdownStatus brokerShutdownStatus) {
            if (brokerShutdownStatus == null) {
                throw new NullPointerException("Null brokerShutdownStatus");
            }
            this.brokerShutdownStatus = brokerShutdownStatus;
            return this;
        }

        @Override
        public RemoveBrokerTaskData.Builder setErrorCode(@Nullable Short errorCode) {
            this.errorCode = Optional.ofNullable(errorCode);
            return this;
        }

        @Override
        public RemoveBrokerTaskData.Builder setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        public RemoveBrokerTaskData.Builder setBroker(Resource.Relationship broker) {
            if (broker == null) {
                throw new NullPointerException("Null broker");
            }
            this.broker = broker;
            return this;
        }

        @Override
        public RemoveBrokerTaskData build() {
            Object missing = "";
            if (this.kind == null) {
                missing = (String)missing + " kind";
            }
            if (this.metadata == null) {
                missing = (String)missing + " metadata";
            }
            if (this.clusterId == null) {
                missing = (String)missing + " clusterId";
            }
            if (this.brokerId == null) {
                missing = (String)missing + " brokerId";
            }
            if (this.shutdownScheduled == null) {
                missing = (String)missing + " shutdownScheduled";
            }
            if (this.brokerReplicaExclusionStatus == null) {
                missing = (String)missing + " brokerReplicaExclusionStatus";
            }
            if (this.partitionReassignmentStatus == null) {
                missing = (String)missing + " partitionReassignmentStatus";
            }
            if (this.brokerShutdownStatus == null) {
                missing = (String)missing + " brokerShutdownStatus";
            }
            if (this.broker == null) {
                missing = (String)missing + " broker";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_RemoveBrokerTaskData(this.kind, this.metadata, this.clusterId, this.brokerId, this.shutdownScheduled, this.brokerReplicaExclusionStatus, this.partitionReassignmentStatus, this.brokerShutdownStatus, this.errorCode, this.errorMessage, this.broker);
        }
    }
}

