/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.BalancerAnyUnevenLoadStatus;
import io.confluent.kafkarest.entities.v3.AutoValue_BalancerAnyUnevenLoadStatusData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Optional;
import org.apache.kafka.clients.admin.EvenClusterLoadStatus;

@AutoValue
public abstract class BalancerAnyUnevenLoadStatusData
extends Resource {
    public static final String ELEMENT_TYPE = "process";

    BalancerAnyUnevenLoadStatusData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="status")
    public abstract EvenClusterLoadStatus getStatus();

    @JsonProperty(value="previous_status")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<EvenClusterLoadStatus> getPreviousStatus();

    @JsonProperty(value="status_updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<Instant> getStatusUpdatedAt();

    @JsonProperty(value="previous_status_updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public abstract Optional<Instant> getPreviousStatusUpdatedAt();

    @JsonProperty(value="error_code")
    public abstract Optional<Short> getErrorCode();

    @JsonProperty(value="error_message")
    public abstract Optional<String> getErrorMessage();

    @JsonProperty(value="broker_tasks")
    public abstract Resource.Relationship getBrokerTasks();

    public static Builder builder() {
        return new AutoValue_BalancerAnyUnevenLoadStatusData.Builder().setKind("KafkaUnevenLoad");
    }

    public static Builder fromAnyUnevenLoad(BalancerAnyUnevenLoadStatus balancerAnyUnevenLoadStatus) {
        return BalancerAnyUnevenLoadStatusData.builder().setClusterId(balancerAnyUnevenLoadStatus.getClusterId()).setStatus(balancerAnyUnevenLoadStatus.getStatus()).setPreviousStatus(balancerAnyUnevenLoadStatus.getPreviousStatus().orElse(null)).setStatusUpdatedAt(balancerAnyUnevenLoadStatus.getStatusUpdatedAt().orElse(null)).setPreviousStatusUpdatedAt(balancerAnyUnevenLoadStatus.getPreviousStatusUpdatedAt().orElse(null)).setErrorCode(balancerAnyUnevenLoadStatus.getErrorCode().orElse(null)).setErrorMessage(balancerAnyUnevenLoadStatus.getErrorMessage().orElse(null));
    }

    @JsonCreator
    static BalancerAnyUnevenLoadStatusData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="status") EvenClusterLoadStatus status, @JsonProperty(value="previous_status") @Nullable EvenClusterLoadStatus previousStatus, @JsonProperty(value="status_updated_at") @Nullable Instant statusUpdatedAt, @JsonProperty(value="previous_status_updated_at") @Nullable Instant previousStatusUpdatedAt, @JsonProperty(value="error_code") @Nullable Short errorCode, @JsonProperty(value="error_message") @Nullable String errorMessage, @JsonProperty(value="broker_tasks") Resource.Relationship brokerTasks) {
        return ((Builder)((Builder)BalancerAnyUnevenLoadStatusData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setStatus(status).setPreviousStatus(previousStatus).setStatusUpdatedAt(statusUpdatedAt).setPreviousStatusUpdatedAt(previousStatusUpdatedAt).setErrorCode(errorCode).setErrorMessage(errorMessage).setBrokerTasks(brokerTasks).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setStatus(EvenClusterLoadStatus var1);

        public abstract Builder setPreviousStatus(@Nullable EvenClusterLoadStatus var1);

        public abstract Builder setStatusUpdatedAt(@Nullable Instant var1);

        public abstract Builder setPreviousStatusUpdatedAt(@Nullable Instant var1);

        public abstract Builder setErrorCode(@Nullable Short var1);

        public abstract Builder setErrorMessage(@Nullable String var1);

        public abstract Builder setBrokerTasks(Resource.Relationship var1);

        public abstract BalancerAnyUnevenLoadStatusData build();
    }
}

