/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.Balancer;
import io.confluent.kafkarest.entities.v3.AutoValue_BalancerData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.apache.kafka.clients.admin.BalancerStatus;

@AutoValue
public abstract class BalancerData
extends Resource {
    public static final String ELEMENT_TYPE = "process";

    BalancerData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="status")
    public abstract BalancerStatus getStatus();

    @JsonProperty(value="error_code")
    public abstract Optional<Short> getErrorCode();

    @JsonProperty(value="error_message")
    public abstract Optional<String> getErrorMessage();

    @JsonProperty(value="any_uneven_load")
    public abstract Resource.Relationship getAnyUnevenLoad();

    @JsonProperty(value="broker_tasks")
    public abstract Resource.Relationship getBrokerTasks();

    public static Builder builder() {
        return new AutoValue_BalancerData.Builder().setKind("KafkaBalancer");
    }

    public static Builder fromBalancer(Balancer balancer) {
        return BalancerData.builder().setClusterId(balancer.getClusterId()).setStatus(balancer.getStatus()).setErrorCode(balancer.getErrorCode().orElse(null)).setErrorMessage(balancer.getErrorMessage().orElse(null));
    }

    @JsonCreator
    static BalancerData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="status") BalancerStatus status, @JsonProperty(value="error_code") @Nullable Short errorCode, @JsonProperty(value="error_message") @Nullable String errorMessage, @JsonProperty(value="any_uneven_load") Resource.Relationship anyUnevenLoad, @JsonProperty(value="broker_tasks") Resource.Relationship brokerTasks) {
        return ((Builder)((Builder)BalancerData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setStatus(status).setErrorCode(errorCode).setErrorMessage(errorMessage).setAnyUnevenLoad(anyUnevenLoad).setBrokerTasks(brokerTasks).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setStatus(BalancerStatus var1);

        public abstract Builder setErrorCode(@Nullable Short var1);

        public abstract Builder setErrorMessage(@Nullable String var1);

        public abstract Builder setAnyUnevenLoad(Resource.Relationship var1);

        public abstract Builder setBrokerTasks(Resource.Relationship var1);

        public abstract BalancerData build();
    }
}

