/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.BrokerRemoval;
import io.confluent.kafkarest.entities.v3.AutoValue_BrokerRemovalData;
import io.confluent.kafkarest.entities.v3.Resource;

@AutoValue
public abstract class BrokerRemovalData
extends Resource {
    BrokerRemovalData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="broker_id")
    public abstract int getBrokerId();

    @JsonProperty(value="broker_task")
    public abstract Resource.Relationship getBrokerTask();

    @JsonProperty(value="broker")
    public abstract Resource.Relationship getBroker();

    public static Builder builder() {
        return new AutoValue_BrokerRemovalData.Builder().setKind("KafkaBrokerRemoval");
    }

    public static Builder fromBrokerRemoval(BrokerRemoval brokerRemoval) {
        return BrokerRemovalData.builder().setClusterId(brokerRemoval.getClusterId()).setBrokerId(brokerRemoval.getBrokerId());
    }

    @JsonCreator
    static BrokerRemovalData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="broker_id") int brokerId, @JsonProperty(value="broker") Resource.Relationship brokerTask, @JsonProperty(value="broker_task") Resource.Relationship broker) {
        return ((Builder)((Builder)BrokerRemovalData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setBrokerId(brokerId).setBrokerTask(brokerTask).setBroker(broker).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setBrokerId(int var1);

        public abstract Builder setBrokerTask(Resource.Relationship var1);

        public abstract Builder setBroker(Resource.Relationship var1);

        public abstract BrokerRemovalData build();
    }
}

