/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.v3.AutoValue_CellData;
import io.confluent.kafkarest.entities.v3.Resource;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.DescribeCellsResponseData;

@AutoValue
public abstract class CellData
extends Resource {
    CellData() {
    }

    @JsonProperty(value="cellId")
    public abstract Integer getCellId();

    @JsonProperty(value="state")
    public abstract byte getState();

    @JsonProperty(value="brokers")
    public abstract List<Integer> getBrokers();

    @JsonProperty(value="openForTenantAssignment")
    public abstract Boolean getOpenForTenantAssignment();

    public static Builder builder() {
        return new AutoValue_CellData.Builder().setKind("Cell");
    }

    public static Builder fromCell(DescribeCellsResponseData.Cell cell) {
        return ((Builder)CellData.builder().setCellId(cell.cellId()).setMetadata(Resource.Metadata.builder().setSelf("cells").setResourceName("cells").build())).setState(cell.state()).setBrokers(cell.brokers()).setOpenForTenantAssignment(cell.openForTenantAssignment());
    }

    public static List<CellData> fromCellList(List<DescribeCellsResponseData.Cell> cells) {
        return cells.stream().map(cell -> CellData.fromCell(cell).build()).collect(Collectors.toList());
    }

    @JsonCreator
    static CellData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cellId") Integer cellId, @JsonProperty(value="state") byte state, @JsonProperty(value="brokers") List<Integer> brokers, @JsonProperty(value="openForTenantAssignment") Boolean openForTenantAssignment) {
        return ((Builder)((Builder)CellData.builder().setKind(kind)).setMetadata(metadata)).setCellId(cellId).setState(state).setBrokers(brokers).setOpenForTenantAssignment(openForTenantAssignment).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setCellId(Integer var1);

        public abstract Builder setState(byte var1);

        public abstract Builder setBrokers(List<Integer> var1);

        public abstract Builder setOpenForTenantAssignment(Boolean var1);

        public abstract CellData build();
    }
}

