/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.CellState;
import io.confluent.kafkarest.entities.v3.AutoValue_CellStateData;
import io.confluent.kafkarest.entities.v3.CellData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;

@AutoValue
public abstract class CellStateData
extends Resource {
    CellStateData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="cells")
    public abstract List<CellData> getCells();

    @JsonProperty(value="cells_enabled")
    public abstract Boolean getCellsEnabled();

    @JsonProperty(value="error_code")
    public abstract Optional<Short> getErrorCode();

    @JsonProperty(value="error_message")
    public abstract Optional<String> getErrorMessage();

    public static Builder builder() {
        return new AutoValue_CellStateData.Builder().setKind("KafkaCells");
    }

    public static Builder fromCellState(CellState cellState) {
        return CellStateData.builder().setClusterId(cellState.getClusterId()).setCells(CellData.fromCellList(cellState.getCells())).setCellsEnabled(cellState.getCellsEnabled()).setErrorCode(cellState.getErrorCode().orElse(null)).setErrorMessage(cellState.getErrorMessage().orElse(null));
    }

    @JsonCreator
    static CellStateData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="cells") List<CellData> cells, @JsonProperty(value="cells_enabled") Boolean cellsEnabled, @JsonProperty(value="error_code") @Nullable Short errorCode, @JsonProperty(value="error_message") @Nullable String errorMessage) {
        return ((Builder)((Builder)CellStateData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setCells(cells).setCellsEnabled(cellsEnabled).setErrorCode(errorCode).setErrorMessage(errorMessage).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setCells(List<CellData> var1);

        public abstract Builder setCellsEnabled(Boolean var1);

        public abstract Builder setErrorCode(@Nullable Short var1);

        public abstract Builder setErrorMessage(@Nullable String var1);

        public abstract CellStateData build();
    }
}

