/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.Link;
import io.confluent.kafkarest.entities.v3.AutoValue_LinkData;
import io.confluent.kafkarest.entities.v3.LinkCategoryData;
import io.confluent.kafkarest.entities.v3.LinkTaskData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.UUID;

@AutoValue
public abstract class LinkData
extends Resource {
    LinkData() {
    }

    @JsonProperty(value="source_cluster_id")
    @Nullable
    public abstract String getSourceClusterId();

    @JsonProperty(value="destination_cluster_id")
    @Nullable
    public abstract String getDestinationClusterId();

    @JsonProperty(value="remote_cluster_id")
    @Nullable
    public abstract String getRemoteClusterId();

    @JsonProperty(value="link_name")
    public abstract String getLinkName();

    @JsonProperty(value="link_id")
    public abstract UUID getLinkId();

    @JsonProperty(value="cluster_link_id")
    public abstract String getClusterLinkId();

    @JsonProperty(value="topic_names")
    public abstract ImmutableList<String> getTopics();

    @JsonProperty(value="link_error")
    public abstract String getLinkError();

    @JsonProperty(value="link_error_message")
    public abstract String getLinkErrorMessage();

    @JsonProperty(value="link_state")
    public abstract String getLinkState();

    @JsonProperty(value="tasks")
    public abstract ImmutableList<LinkTaskData> getTasks();

    @JsonProperty(value="category_counts")
    public abstract ImmutableList<LinkCategoryData> getCategoryCounts();

    public static Builder builder() {
        return new AutoValue_LinkData.Builder().setKind("KafkaLinkData");
    }

    public static Builder fromLinkData(LinkData linkData) {
        return LinkData.builder().setLinkName(linkData.getLinkName()).setSourceClusterId(linkData.getSourceClusterId()).setDestinationClusterId(linkData.getDestinationClusterId()).setRemoteClusterId(linkData.getRemoteClusterId()).setLinkId(linkData.getLinkId()).setClusterLinkId(linkData.getClusterLinkId()).setTopics(linkData.getTopics()).setLinkError(linkData.getLinkError()).setLinkErrorMessage(linkData.getLinkErrorMessage()).setLinkState(linkData.getLinkState()).setTasks(linkData.getTasks()).setCategoryCounts(linkData.getCategoryCounts());
    }

    public static Builder fromLink(Link link) {
        String sourceClusterId = null;
        String destinationClusterId = null;
        switch (link.getLinkMode()) {
            case DESTINATION: {
                sourceClusterId = link.getRemoteClusterId();
                break;
            }
            case SOURCE: {
                destinationClusterId = link.getRemoteClusterId();
                break;
            }
        }
        String linkError = link.getLinkError() != null ? link.getLinkError().name() : null;
        ImmutableList categoryCounts = link.getCategoryCounts() != null ? (ImmutableList)link.getCategoryCounts().entrySet().stream().map(LinkCategoryData::fromEntry).collect(ImmutableList.toImmutableList()) : ImmutableList.of();
        return LinkData.builder().setLinkName(link.getLinkName()).setSourceClusterId(sourceClusterId).setDestinationClusterId(destinationClusterId).setRemoteClusterId(link.getRemoteClusterId()).setLinkId(link.getLinkId()).setClusterLinkId(link.getClusterLinkId().toString()).setTopics(link.getTopics()).setLinkError(linkError).setLinkErrorMessage(link.getLinkErrorMessage()).setLinkState(link.getLinkState().name()).setTasks((ImmutableList<LinkTaskData>)((ImmutableList)link.getTasks().stream().map(task -> LinkTaskData.fromClusterLinkTaskDescription(task)).collect(ImmutableList.toImmutableList()))).setCategoryCounts((ImmutableList<LinkCategoryData>)categoryCounts);
    }

    @JsonCreator
    static LinkData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="source_cluster_id") String sourceClusterId, @JsonProperty(value="destination_cluster_id") String destinationClusterId, @JsonProperty(value="link_name") String linkName, @JsonProperty(value="link_id") UUID linkId, @JsonProperty(value="cluster_link_id") String clusterLinkId, @JsonProperty(value="topic_names") ImmutableList<String> topics, @JsonProperty(value="link_error") String linkError, @JsonProperty(value="link_error_message") String linkErrorMessage, @JsonProperty(value="link_state") String linkState, @JsonProperty(value="tasks") ImmutableList<LinkTaskData> tasks, @JsonProperty(value="category_counts") ImmutableList<LinkCategoryData> categoryCounts) {
        return ((Builder)((Builder)LinkData.builder().setKind(kind)).setMetadata(metadata)).setLinkName(linkName).setSourceClusterId(sourceClusterId).setDestinationClusterId(destinationClusterId).setLinkId(linkId).setClusterLinkId(clusterLinkId).setTopics(topics).setLinkError(linkError).setLinkErrorMessage(linkErrorMessage).setLinkState(linkState).setTasks(tasks).setCategoryCounts(categoryCounts).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setSourceClusterId(String var1);

        public abstract Builder setDestinationClusterId(String var1);

        public abstract Builder setRemoteClusterId(String var1);

        public abstract Builder setLinkName(String var1);

        public abstract Builder setLinkId(UUID var1);

        public abstract Builder setClusterLinkId(String var1);

        public abstract Builder setTopics(ImmutableList<String> var1);

        public abstract Builder setLinkError(String var1);

        public abstract Builder setLinkErrorMessage(String var1);

        public abstract Builder setLinkState(String var1);

        public abstract Builder setTasks(ImmutableList<LinkTaskData> var1);

        public abstract Builder setCategoryCounts(ImmutableList<LinkCategoryData> var1);

        public abstract LinkData build();
    }
}

