/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.AutoValue_LinkTaskData;
import io.confluent.kafkarest.entities.v3.LinkTaskErrorData;
import jakarta.annotation.Nullable;
import org.apache.kafka.clients.admin.ClusterLinkTaskDescription;

@AutoValue
public abstract class LinkTaskData {
    @JsonProperty(value="task_name")
    @Nullable
    public abstract String getTaskName();

    @JsonProperty(value="state")
    public abstract String getState();

    @JsonProperty(value="errors")
    public abstract ImmutableList<LinkTaskErrorData> getErrors();

    public static Builder builder() {
        return new AutoValue_LinkTaskData.Builder();
    }

    @JsonCreator
    static LinkTaskData fromJson(@JsonProperty(value="task_name") String taskName, @JsonProperty(value="state") String state, @JsonProperty(value="errors") ImmutableList<LinkTaskErrorData> errors) {
        return LinkTaskData.builder().setTaskName(taskName).setState(state).setErrors(errors).build();
    }

    public static LinkTaskData fromClusterLinkTaskDescription(ClusterLinkTaskDescription taskDescription) {
        return LinkTaskData.builder().setTaskName(taskDescription.name()).setState(taskDescription.state().name()).setErrors((ImmutableList<LinkTaskErrorData>)((ImmutableList)taskDescription.errors().stream().map(err -> LinkTaskErrorData.fromClusterLinkTaskError(err)).collect(ImmutableList.toImmutableList()))).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTaskName(String var1);

        public abstract Builder setState(String var1);

        public abstract Builder setErrors(ImmutableList<LinkTaskErrorData> var1);

        public abstract LinkTaskData build();
    }
}

