/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.AutoValue_PartitionTruncationData;
import io.confluent.kafkarest.entities.v3.PartitionTruncationInfo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@AutoValue
public abstract class PartitionTruncationData {
    PartitionTruncationData() {
    }

    @JsonProperty(value="partition_id")
    public abstract Integer getPartitionId();

    @JsonProperty(value="offset_truncated_to")
    public abstract Long getOffsetTruncatedTo();

    @JsonProperty(value="messages_truncated")
    public abstract Long getMessagesTruncated();

    public static Builder builder() {
        return new AutoValue_PartitionTruncationData.Builder();
    }

    @JsonCreator
    static PartitionTruncationData fromJson(@JsonProperty(value="partition_id") Integer partitionId, @JsonProperty(value="offset_truncated_to") Long offsetTruncatedTo, @JsonProperty(value="messages_truncated") Long messagesTruncated) {
        return PartitionTruncationData.builder().setPartitionId(partitionId).setOffsetTruncatedTo(offsetTruncatedTo).setMessagesTruncated(messagesTruncated).build();
    }

    public static ImmutableList<PartitionTruncationData> fromPartitionTruncationInfo(List<PartitionTruncationInfo> partitionTruncationInfoList) {
        return ImmutableList.copyOf((Collection)partitionTruncationInfoList.stream().map(partitionInfo -> PartitionTruncationData.fromPartitionInfo(partitionInfo.getPartitionId(), partitionInfo.getOffsetTruncatedTo(), partitionInfo.getMessagesTruncated()).build()).collect(Collectors.toList()));
    }

    public static Builder fromPartitionInfo(Integer partitionId, Long offsetTruncatedTo, Long messagesTruncated) {
        return PartitionTruncationData.builder().setPartitionId(partitionId).setOffsetTruncatedTo(offsetTruncatedTo).setMessagesTruncated(messagesTruncated);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setPartitionId(Integer var1);

        public abstract Builder setOffsetTruncatedTo(Long var1);

        public abstract Builder setMessagesTruncated(Long var1);

        public abstract PartitionTruncationData build();
    }
}

