/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.entities.ReplicaStatus;
import io.confluent.kafkarest.entities.v3.AutoValue_ReplicaStatusData;
import io.confluent.kafkarest.entities.v3.Resource;
import jakarta.annotation.Nullable;
import java.util.Optional;

@AutoValue
public abstract class ReplicaStatusData
extends Resource {
    ReplicaStatusData() {
    }

    @JsonProperty(value="cluster_id")
    public abstract String getClusterId();

    @JsonProperty(value="topic_name")
    public abstract String getTopicName();

    @JsonProperty(value="broker_id")
    public abstract int getBrokerId();

    @JsonProperty(value="partition_id")
    public abstract int getPartitionId();

    @JsonProperty(value="is_leader")
    public abstract boolean isLeader();

    @JsonProperty(value="is_observer")
    public abstract boolean isObserver();

    @JsonProperty(value="is_isr_eligible")
    public abstract boolean isIsrEligible();

    @JsonProperty(value="is_in_isr")
    public abstract boolean isInIsr();

    @JsonProperty(value="is_caught_up")
    public abstract boolean isCaughtUp();

    @JsonProperty(value="log_start_offset")
    public abstract long getLogStartOffset();

    @JsonProperty(value="log_end_offset")
    public abstract long getLogEndOffset();

    @JsonProperty(value="last_caught_up_time_ms")
    public abstract long getLastCaughtUpTimeMs();

    @JsonProperty(value="last_fetch_time_ms")
    public abstract long getLastFetchTimeMs();

    @JsonProperty(value="link_name")
    public abstract Optional<String> getLinkName();

    public static Builder builder() {
        return new AutoValue_ReplicaStatusData.Builder().setKind("KafkaReplicaStatus");
    }

    public static Builder fromReplicaStatus(ReplicaStatus replicaStatus) {
        return ReplicaStatusData.builder().setClusterId(replicaStatus.getClusterId()).setInIsr(replicaStatus.isInIsr()).setCaughtUp(replicaStatus.isCaughtUp()).setBrokerId(replicaStatus.getBrokerId()).setIsrEligible(replicaStatus.isIsrEligible()).setLastCaughtUpTimeMs(replicaStatus.getLastCaughtUpTimeMs()).setLastFetchTimeMs(replicaStatus.getLastFetchTimeMs()).setLeader(replicaStatus.isLeader()).setLinkName(replicaStatus.getLinkName().orElse(null)).setLogEndOffset(replicaStatus.getLogEndOffset()).setLogStartOffset(replicaStatus.getLogStartOffset()).setObserver(replicaStatus.isObserver()).setPartitionId(replicaStatus.getPartitionId()).setTopicName(replicaStatus.getTopicName());
    }

    @JsonCreator
    static ReplicaStatusData fromJson(@JsonProperty(value="kind") String kind, @JsonProperty(value="metadata") Resource.Metadata metadata, @JsonProperty(value="cluster_id") String clusterId, @JsonProperty(value="topic_name") String topicName, @JsonProperty(value="broker_id") int brokerId, @JsonProperty(value="partition_id") int partitionId, @JsonProperty(value="is_leader") boolean isLeader, @JsonProperty(value="is_observer") boolean isObserver, @JsonProperty(value="is_isr_eligible") boolean isIsrEligible, @JsonProperty(value="is_in_isr") boolean isInIsr, @JsonProperty(value="is_caught_up") boolean isCaughtUp, @JsonProperty(value="log_start_offset") long logStartOffset, @JsonProperty(value="log_end_offset") long logEndOffset, @JsonProperty(value="last_caught_up_time_ms") long lastCaughtUpTimeMs, @JsonProperty(value="last_fetch_time_ms") long lastFetchTimeMs, @JsonProperty(value="link_name") String linkName) {
        return ((Builder)((Builder)ReplicaStatusData.builder().setKind(kind)).setMetadata(metadata)).setClusterId(clusterId).setTopicName(topicName).setBrokerId(brokerId).setPartitionId(partitionId).setLeader(isLeader).setObserver(isObserver).setIsrEligible(isIsrEligible).setInIsr(isInIsr).setCaughtUp(isCaughtUp).setLogStartOffset(logStartOffset).setLogEndOffset(logEndOffset).setLastCaughtUpTimeMs(lastCaughtUpTimeMs).setLastFetchTimeMs(lastFetchTimeMs).setLinkName(linkName).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends Resource.Builder<Builder> {
        Builder() {
        }

        public abstract Builder setClusterId(String var1);

        public abstract Builder setTopicName(String var1);

        public abstract Builder setBrokerId(int var1);

        public abstract Builder setPartitionId(int var1);

        public abstract Builder setLeader(boolean var1);

        public abstract Builder setObserver(boolean var1);

        public abstract Builder setIsrEligible(boolean var1);

        public abstract Builder setInIsr(boolean var1);

        public abstract Builder setCaughtUp(boolean var1);

        public abstract Builder setLogStartOffset(long var1);

        public abstract Builder setLogEndOffset(long var1);

        public abstract Builder setLastCaughtUpTimeMs(long var1);

        public abstract Builder setLastFetchTimeMs(long var1);

        public abstract Builder setLinkName(@Nullable String var1);

        public abstract ReplicaStatusData build();
    }
}

