/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.v3.AutoValue_UpdateConsumerGroupOffsetsRequest;
import io.confluent.kafkarest.entities.v3.AutoValue_UpdateConsumerGroupOffsetsRequest_OffsetData;
import io.confluent.kafkarest.entities.v3.AutoValue_UpdateConsumerGroupOffsetsRequest_TopicPartitionOffsetData;
import jakarta.annotation.Nullable;
import java.util.List;

@AutoValue
public abstract class UpdateConsumerGroupOffsetsRequest {
    UpdateConsumerGroupOffsetsRequest() {
    }

    @JsonProperty(value="topic_partition_offsets")
    public abstract ImmutableList<TopicPartitionOffsetData> getTopicPartitionOffsetRequests();

    public static Builder builder() {
        return new AutoValue_UpdateConsumerGroupOffsetsRequest.Builder();
    }

    @JsonCreator
    static UpdateConsumerGroupOffsetsRequest fromJson(@JsonProperty(value="topic_partition_offsets") List<TopicPartitionOffsetData> topicPartitionOffsetRequests) {
        return UpdateConsumerGroupOffsetsRequest.builder().setTopicPartitionOffsetRequests(topicPartitionOffsetRequests).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setTopicPartitionOffsetRequests(List<TopicPartitionOffsetData> var1);

        public abstract UpdateConsumerGroupOffsetsRequest build();
    }

    public static enum OffsetType {
        OFFSET,
        EARLIEST,
        LATEST;

    }

    @AutoValue
    public static abstract class OffsetData {
        OffsetData() {
        }

        @JsonProperty(value="offset")
        @Nullable
        public abstract Long getOffset();

        @JsonProperty(value="offset_type")
        public abstract OffsetType getOffsetType();

        public static OffsetData create(@Nullable Long offset, OffsetType offsetType) {
            return new AutoValue_UpdateConsumerGroupOffsetsRequest_OffsetData(offset, offsetType);
        }

        @JsonCreator
        static OffsetData fromJson(@Nullable @JsonProperty(value="offset") Long offset, @JsonProperty(value="offset_type") OffsetType offsetType) {
            return OffsetData.create(offset, offsetType);
        }
    }

    @AutoValue
    public static abstract class TopicPartitionOffsetData {
        TopicPartitionOffsetData() {
        }

        @JsonProperty(value="topic_name")
        public abstract String getTopicName();

        @JsonProperty(value="partition_id")
        public abstract Integer getPartitionId();

        @JsonProperty(value="offset_data")
        public abstract OffsetData getOffsetData();

        public static TopicPartitionOffsetData create(String topicName, Integer partitionId, OffsetData offsetData) {
            return new AutoValue_UpdateConsumerGroupOffsetsRequest_TopicPartitionOffsetData(topicName, partitionId, offsetData);
        }

        @JsonCreator
        static TopicPartitionOffsetData fromJson(@JsonProperty(value="topic_name") String topicName, @JsonProperty(value="partition_id") Integer partitionId, @JsonProperty(value="offset_data") OffsetData offsetData) {
            return TopicPartitionOffsetData.create(topicName, partitionId, offsetData);
        }
    }
}

