/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.exceptions;

import com.google.auto.value.AutoValue;
import io.confluent.kafkarest.exceptions.AutoValue_ConsumerGroupOffsetsUtils_Error;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsumerGroupOffsetsUtils {
    private static final Logger log = LoggerFactory.getLogger(ConsumerGroupOffsetsUtils.class);
    public static final String INTERNAL_SERVER_ERROR_MSG_LIST_OFFSETS_TMPL = "Unexpected server error while listing offsets for %s";
    public static final String INTERNAL_SERVER_ERROR_MSG_ALTER_OFFSETS_TMPL = "Unexpected server error while altering offsets for %s";
    public static final String UNAUTHORIZED_ERROR_MSG_LIST_OFFSETS_TMPL = "Unauthorized to list offsets for %s";
    public static final String UNAUTHORIZED_ERROR_MSG_ALTER_OFFSETS_TMPL = "Unauthorized to alter offsets for %s";
    public static final String GROUP_UNAUTHORIZED_ERROR_MSG_ALTER_OFFSETS_TMPL = "Group unauthorized to alter offsets for %s";
    public static final String TOPIC_UNAUTHORIZED_ERROR_MSG_ALTER_OFFSETS_TMPL = "Topic unauthorized to alter offsets for %s";
    public static final String BAD_REQUEST_ERROR_MSG_ALTER_OFFSETS_TMPL = "Topic-partition %s doesn't exist.";

    private ConsumerGroupOffsetsUtils() {
    }

    public static Error mapListOffsetExecutionExceptionToError(ExecutionException ee, TopicPartition tp, String consumerGroupId) {
        String errorMessage;
        int errorCode;
        Throwable cause = ee.getCause();
        if (cause instanceof AuthorizationException) {
            errorCode = Response.Status.UNAUTHORIZED.getStatusCode();
            errorMessage = String.format(UNAUTHORIZED_ERROR_MSG_LIST_OFFSETS_TMPL, tp);
            log.debug("Received auth-error listing offset for group: {}, topic-partition: {}: {}", new Object[]{consumerGroupId, tp, ee.getCause()});
        } else {
            errorCode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
            errorMessage = String.format(INTERNAL_SERVER_ERROR_MSG_LIST_OFFSETS_TMPL, tp);
            log.error("Received error listing offset for group: {}, topic-partition: {}: {}", new Object[]{consumerGroupId, tp, ee.getCause()});
        }
        return Error.create(errorCode, errorMessage);
    }

    public static Error mapAlterOffsetExecutionExceptionToError(ExecutionException ee, TopicPartition tp, String consumerGroupId) {
        String errorMessage;
        int errorCode;
        Throwable cause = ee.getCause();
        if (cause instanceof AuthorizationException) {
            errorCode = Response.Status.UNAUTHORIZED.getStatusCode();
            errorMessage = cause instanceof GroupAuthorizationException ? String.format(GROUP_UNAUTHORIZED_ERROR_MSG_ALTER_OFFSETS_TMPL, tp) : (cause instanceof TopicAuthorizationException ? String.format(TOPIC_UNAUTHORIZED_ERROR_MSG_ALTER_OFFSETS_TMPL, tp) : String.format(UNAUTHORIZED_ERROR_MSG_ALTER_OFFSETS_TMPL, tp));
            log.debug("Received authz-error altering offset for group: {}, topic-partition: {}: {}", new Object[]{consumerGroupId, tp, ee.getCause()});
        } else if (cause instanceof UnknownTopicOrPartitionException) {
            errorCode = Response.Status.BAD_REQUEST.getStatusCode();
            errorMessage = String.format(BAD_REQUEST_ERROR_MSG_ALTER_OFFSETS_TMPL, tp);
            log.debug("Received error while resetting offset for group: {}, topic-partition: {}: {}", new Object[]{consumerGroupId, tp, ee.getCause()});
        } else {
            errorCode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
            errorMessage = String.format(INTERNAL_SERVER_ERROR_MSG_ALTER_OFFSETS_TMPL, tp);
            log.error("Received error while resetting offset for group: {}, topic-partition: {}: {}", new Object[]{consumerGroupId, tp, ee.getCause()});
        }
        return Error.create(errorCode, errorMessage);
    }

    @AutoValue
    public static abstract class Error {
        public static Error create(int errorCode, String errorMessage) {
            return new AutoValue_ConsumerGroupOffsetsUtils_Error(errorCode, errorMessage);
        }

        public abstract int errorCode();

        public abstract String errorMessage();
    }
}

