/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.exceptions;

import io.confluent.kafkarest.exceptions.ErrorCodes;
import io.confluent.kafkarest.exceptions.StatusCodeException;
import jakarta.ws.rs.core.Response;
import org.apache.kafka.common.ClusterLinkError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InvalidClusterLinkException
extends StatusCodeException {
    private static Logger log = LoggerFactory.getLogger(InvalidClusterLinkException.class);

    public InvalidClusterLinkException(org.apache.kafka.common.errors.InvalidClusterLinkException e) {
        super(Response.Status.BAD_REQUEST, InvalidClusterLinkException.applicationErrorCode(e.clusterLinkError(), e), "Invalid Cluster Link", InvalidClusterLinkException.detailedErrorMessage(e), (Throwable)e);
    }

    private static String detailedErrorMessage(org.apache.kafka.common.errors.InvalidClusterLinkException e) {
        switch (e.clusterLinkError()) {
            case UNKNOWN: 
            case TIMEOUT_ERROR: 
            case AUTHENTICATION_ERROR: 
            case AUTHORIZATION_ERROR: {
                throw new IllegalStateException(String.format("LinkError is %s which should not happen in %s", e.clusterLinkError().name(), e.getClass().getSimpleName()));
            }
            case UNRESOLVABLE_BOOTSTRAP_ERROR: 
            case INVALID_BOOTSTRAP_INTERNAL_ENDPOINT_ERROR: 
            case BOOTSTRAP_TCP_CONNECTION_FAILED_ERROR: {
                if (e.linkErrorMessage() != null) {
                    return String.format("Invalid cluster link. Link error code: %s. Link error message: %s. Error message: %s", e.clusterLinkError().name(), e.linkErrorMessage(), e.getMessage());
                }
                return String.format("Invalid cluster link. Link error code: %s. Error message: %s", e.clusterLinkError().name(), e.getMessage());
            }
            case NO_ERROR: {
                return String.format("Invalid cluster link. Error message: %s", e.getMessage());
            }
        }
        return String.format("Invalid cluster link with unknown underlying link error code. Error message: %s", e.getMessage());
    }

    private static int applicationErrorCode(ClusterLinkError linkError, org.apache.kafka.common.errors.InvalidClusterLinkException e) {
        switch (linkError) {
            case UNKNOWN: 
            case TIMEOUT_ERROR: 
            case AUTHENTICATION_ERROR: 
            case AUTHORIZATION_ERROR: 
            case RETRIABLE_RECONFIGURATION_ERROR: {
                throw new IllegalStateException(String.format("LinkError is %s which should not happen in %s", linkError.name(), e.getClass().getSimpleName()));
            }
            case UNRESOLVABLE_BOOTSTRAP_ERROR: {
                return ErrorCodes.CLUSTER_LINK_UNRESOLVABLE_BOOTSTRAP_ERROR_CODE;
            }
            case INVALID_BOOTSTRAP_INTERNAL_ENDPOINT_ERROR: {
                return ErrorCodes.CLUSTER_LINK_INVALID_BOOTSTRAP_INTERNAL_ERROR_CODE;
            }
            case BOOTSTRAP_TCP_CONNECTION_FAILED_ERROR: {
                return ErrorCodes.CLUSTER_LINK_BOOTSTRAP_TCP_CONNECTION_FAILED_ERROR_CODE;
            }
            case NO_ERROR: {
                return Response.Status.BAD_REQUEST.getStatusCode();
            }
        }
        log.warn("Unexpected link error {}", (Object)linkError);
        return Response.Status.BAD_REQUEST.getStatusCode();
    }
}

