/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.exceptions;

import io.confluent.kafkarest.exceptions.StatusCodeException;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.stream.Collectors;

public final class MirrorTopicNotFoundException
extends StatusCodeException {
    public MirrorTopicNotFoundException(String topic) {
        super(Response.Status.NOT_FOUND, "The mirror topic doesn't exist", topic);
    }

    public MirrorTopicNotFoundException(Collection<String> expect, Collection<String> actual) {
        super(Response.Status.NOT_FOUND, "The mirror topic doesn't exist", expect.stream().filter(topic -> !actual.contains(topic)).collect(Collectors.joining(",")));
    }

    public MirrorTopicNotFoundException(Throwable e) {
        super(Response.Status.NOT_FOUND, "The mirror topic doesn't exist", e.getMessage(), e);
    }
}

