/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.extensions;

import io.confluent.kafkarest.resources.v3.ProduceAction;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.util.Objects;
import org.apache.kafka.clients.producer.Producer;

public final class ForceProduceAuthenticationFeature
implements DynamicFeature {
    private final Provider<Producer<byte[], byte[]>> producer;

    @Inject
    ForceProduceAuthenticationFeature(Provider<Producer<byte[], byte[]>> producer) {
        this.producer = Objects.requireNonNull(producer);
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        if (resourceInfo.getResourceClass().equals(ProduceAction.class)) {
            featureContext.register((Object)new ForceProduceAuthenticationFilter(this.producer));
        }
    }

    @Priority(value=0x7FFFFFFF)
    private static final class ForceProduceAuthenticationFilter
    implements ContainerRequestFilter {
        private final Provider<Producer<byte[], byte[]>> producer;

        private ForceProduceAuthenticationFilter(Provider<Producer<byte[], byte[]>> producer) {
            this.producer = Objects.requireNonNull(producer);
        }

        public void filter(ContainerRequestContext containerRequestContext) {
            String topicName = (String)containerRequestContext.getUriInfo().getPathParameters().getFirst((Object)"topicName");
            ((Producer)this.producer.get()).partitionsFor(topicName);
        }
    }
}

