/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources;

import io.confluent.kafkarest.controllers.HealthCheckManager;
import io.confluent.kafkarest.entities.HealthCheckStatusResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Path(value="/health")
@Produces(value={"application/json"})
@ResourceAccesslistFeature.ResourceName(value="api.health.*")
public final class HealthCheckAction {
    private final Provider<HealthCheckManager> healthCheckManager;

    @Inject
    public HealthCheckAction(Provider<HealthCheckManager> healthCheckManager) {
        this.healthCheckManager = Objects.requireNonNull(healthCheckManager);
    }

    @GET
    @ResourceAccesslistFeature.ResourceName(value="api.health.get")
    public void getServiceHealth(@Suspended AsyncResponse asyncResponse) {
        CompletionStage response = ((HealthCheckManager)this.healthCheckManager.get()).getHealthCheckStatus().thenApply(HealthCheckStatusResponse::create);
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }
}

