/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.LinkConfigManager;
import io.confluent.kafkarest.entities.v3.AlterLinkConfigBatchRequest;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

@Path(value="/v3/clusters/{clusterId}/links/{linkName}/configs:alter")
@ResourceAccesslistFeature.ResourceName(value="api.v3.link-configs.*")
public final class AlterLinkConfigBatchAction {
    private final Provider<LinkConfigManager> linkConfigManager;

    @Inject
    public AlterLinkConfigBatchAction(Provider<LinkConfigManager> linkConfigManager) {
        this.linkConfigManager = Objects.requireNonNull(linkConfigManager);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.link-configs.alter")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.link-configs.alter")
    public void alterLink(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName, @QueryParam(value="validate_only") @DefaultValue(value="false") boolean validateOnly, @Valid AlterLinkConfigBatchRequest request) {
        CompletableFuture<Void> response = ((LinkConfigManager)this.linkConfigManager.get()).alterLinkConfigs(clusterId, linkName, request.getValue().toAlterConfigCommands(), validateOnly);
        AsyncResponses.AsyncResponseBuilder.from((Response.ResponseBuilder)Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }
}

