/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.BrokerReplicaExclusionManager;
import io.confluent.kafkarest.entities.AlterBrokerReplicaExclusion;
import io.confluent.kafkarest.entities.BrokerReplicaExclusion;
import io.confluent.kafkarest.entities.v3.AlterBrokerReplicaExclusionData;
import io.confluent.kafkarest.entities.v3.BrokerReplicaExclusionData;
import io.confluent.kafkarest.entities.v3.BrokerReplicaExclusionDataList;
import io.confluent.kafkarest.entities.v3.GetBrokerReplicaExclusionResponse;
import io.confluent.kafkarest.entities.v3.ListBrokerReplicaExclusionResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Path(value="/v3/clusters/{clusterId}/broker-replica-exclusions")
@ResourceAccesslistFeature.ResourceName(value="api.v3.broker-replica-exclusions.*")
public final class BrokerReplicaExclusionResource {
    private final Provider<BrokerReplicaExclusionManager> brokerReplicaExclusionManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public BrokerReplicaExclusionResource(Provider<BrokerReplicaExclusionManager> brokerReplicaExclusionManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.brokerReplicaExclusionManager = Objects.requireNonNull(brokerReplicaExclusionManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.broker-replica-exclusions.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.broker-replica-exclusions.list")
    public void listBrokerReplicaExclusions(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((BrokerReplicaExclusionManager)this.brokerReplicaExclusionManager.get()).listBrokerReplicaExclusions(clusterId).thenApply(brokerReplicaExclusions -> ListBrokerReplicaExclusionResponse.create((BrokerReplicaExclusionDataList)((BrokerReplicaExclusionDataList.Builder)((BrokerReplicaExclusionDataList.Builder)BrokerReplicaExclusionDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "broker-replica-exclusions"})).build())).setData(brokerReplicaExclusions.stream().map(brokerReplicaExclusion -> BrokerReplicaExclusionResource.toBrokerReplicaExclusionData(this.urlFactory, this.crnFactory, brokerReplicaExclusion)).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    @GET
    @Path(value="/{brokerId}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.broker-replica-exclusions.search-by-broker")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.broker-replica-exclusions.search-by-broker")
    public void getBrokerReplicaExclusion(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") int brokerId) {
        CompletionStage response = ((CompletableFuture)((BrokerReplicaExclusionManager)this.brokerReplicaExclusionManager.get()).getBrokerReplicaExclusions(clusterId, brokerId).thenApply(brokerReplicaExclusion -> (BrokerReplicaExclusion)brokerReplicaExclusion.orElseThrow(NotFoundException::new))).thenApply(brokerReplicaExclusion -> GetBrokerReplicaExclusionResponse.create(BrokerReplicaExclusionResource.toBrokerReplicaExclusionData(this.urlFactory, this.crnFactory, brokerReplicaExclusion)));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    static BrokerReplicaExclusionData toBrokerReplicaExclusionData(UrlFactory urlFactory, CrnFactory crnFactory, BrokerReplicaExclusion brokerReplicaExclusion) {
        return ((BrokerReplicaExclusionData.Builder)BrokerReplicaExclusionData.fromBrokerReplicaExclusion(brokerReplicaExclusion).setMetadata(Resource.Metadata.builder().setSelf(urlFactory.create(new String[]{"v3", "clusters", brokerReplicaExclusion.getClusterId(), "broker-replica-exclusions", Integer.toString(brokerReplicaExclusion.getBrokerId())})).setResourceName(crnFactory.create(new String[]{"kafka", brokerReplicaExclusion.getClusterId(), "broker-replica-exclusions", Integer.toString(brokerReplicaExclusion.getBrokerId())})).build())).setBroker(Resource.Relationship.create((String)urlFactory.create(new String[]{"v3", "clusters", brokerReplicaExclusion.getClusterId(), "brokers", Integer.toString(brokerReplicaExclusion.getBrokerId())}))).build();
    }

    static AlterBrokerReplicaExclusionData toAlterBrokerReplicaExclusionData(UrlFactory urlFactory, CrnFactory crnFactory, AlterBrokerReplicaExclusion alterBrokerReplicaExclusion) {
        return ((AlterBrokerReplicaExclusionData.Builder)AlterBrokerReplicaExclusionData.fromAlterBrokerReplicaExclusion(alterBrokerReplicaExclusion).setMetadata(Resource.Metadata.builder().setSelf(urlFactory.create(new String[]{"v3", "clusters", alterBrokerReplicaExclusion.getClusterId(), "broker-replica-exclusions", Integer.toString(alterBrokerReplicaExclusion.getBrokerId())})).setResourceName(crnFactory.create(new String[]{"kafka", alterBrokerReplicaExclusion.getClusterId(), "broker-replica-exclusions", Integer.toString(alterBrokerReplicaExclusion.getBrokerId())})).build())).setBroker(Resource.Relationship.create((String)urlFactory.create(new String[]{"v3", "clusters", alterBrokerReplicaExclusion.getClusterId(), "brokers", Integer.toString(alterBrokerReplicaExclusion.getBrokerId())}))).build();
    }
}

