/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.CellsManager;
import io.confluent.kafkarest.entities.v3.CellStateData;
import io.confluent.kafkarest.entities.v3.DescribeCellsResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Path(value="/v3/clusters/{clusterId}/cells")
@ResourceAccesslistFeature.ResourceName(value="api.v3.cells.*")
public final class CellsResource {
    private final Provider<CellsManager> cellsManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public CellsResource(Provider<CellsManager> cellsManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.cellsManager = Objects.requireNonNull(cellsManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    public void describeCells(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((CellsManager)this.cellsManager.get()).describeCells(clusterId).thenApply(cellState -> DescribeCellsResponse.create(((CellStateData.Builder)CellStateData.fromCellState(cellState).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", cellState.getClusterId(), "cells"})).setResourceName(this.crnFactory.create(new String[]{"kafka", "clusters", cellState.getClusterId(), "cells"})).build())).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }
}

