/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.ConsumerGroupManager;
import io.confluent.kafkarest.controllers.ConsumerGroupOffsetsManager;
import io.confluent.kafkarest.entities.ConsumerGroup;
import io.confluent.kafkarest.entities.v3.UpdateConsumerGroupOffsetsRequest;
import io.confluent.kafkarest.exceptions.BadRequestException;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import io.confluent.rest.exceptions.RestNotFoundException;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.jetty.http.HttpStatus;

@Path(value="/v3/clusters/{clusterId}/internal/consumer-groups/{consumerGroupId}/offsets")
@ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-groups.offsets.*")
public final class ConsumerGroupOffsetsResource {
    private final Provider<ConsumerGroupOffsetsManager> consumerGroupOffsetsManager;
    private final Provider<ConsumerGroupManager> consumerGroupManager;
    public static final String ALTER_OFFSETS_INVALID_CONSUMER_GROUP_STATE_ERROR_TMPL = "%s has state %s, alter offsets only allowed in state 'empty' or 'dead'.";

    @Inject
    public ConsumerGroupOffsetsResource(Provider<ConsumerGroupOffsetsManager> consumerGroupOffsetsManager, Provider<ConsumerGroupManager> consumerGroupManager) {
        this.consumerGroupOffsetsManager = Objects.requireNonNull(consumerGroupOffsetsManager);
        this.consumerGroupManager = Objects.requireNonNull(consumerGroupManager);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-groups.offsets.get")
    @PerformanceMetric(value="api.v3.consumer-groups.offsets.get")
    public void getConsumerGroupOffsets(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId) {
        ConsumerGroupOffsetsManager manager = (ConsumerGroupOffsetsManager)this.consumerGroupOffsetsManager.get();
        CompletionStage responseFuture = this.checkConsumerGroupExists(clusterId, consumerGroupId).thenCompose(consumerGroup -> manager.getConsumerGroupOffsets(consumerGroupId));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)responseFuture);
    }

    @PATCH
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.consumer-groups.offsets.patch")
    @PerformanceMetric(value="api.v3.consumer-groups.offsets.patch")
    public void updateConsumerGroupOffset(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId, @Valid UpdateConsumerGroupOffsetsRequest request) {
        ConsumerGroupOffsetsManager manager = (ConsumerGroupOffsetsManager)this.consumerGroupOffsetsManager.get();
        if (request == null) {
            throw Errors.invalidPayloadException((String)"Null input provided. Data is required.");
        }
        CompletionStage responseFuture = ((CompletableFuture)this.checkConsumerGroupExists(clusterId, consumerGroupId).thenApply(consumerGroup -> {
            ConsumerGroup.State state = consumerGroup.getState();
            if (!ConsumerGroup.State.EMPTY.equals((Object)state) && !ConsumerGroup.State.DEAD.equals((Object)state)) {
                throw new BadRequestException(String.format(ALTER_OFFSETS_INVALID_CONSUMER_GROUP_STATE_ERROR_TMPL, consumerGroupId, state));
            }
            return consumerGroup;
        })).thenCompose(consumerGroup -> manager.updateConsumerGroupOffsets(consumerGroupId, request));
        AsyncResponses.AsyncResponseBuilder.from((Response.ResponseBuilder)Response.status((int)HttpStatus.Code.MULTI_STATUS.getCode(), (String)HttpStatus.Code.MULTI_STATUS.getMessage())).entity((CompletableFuture)responseFuture).asyncResume(asyncResponse);
    }

    private CompletableFuture<ConsumerGroup> checkConsumerGroupExists(String clusterId, String consumerGroupId) {
        return ((ConsumerGroupManager)this.consumerGroupManager.get()).getConsumerGroup(clusterId, consumerGroupId).thenApply(consumerGroup -> (ConsumerGroup)consumerGroup.orElseThrow(() -> new RestNotFoundException("Consumer group id not found.", 40405)));
    }
}

