/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.DefaultTopicConfigManager;
import io.confluent.kafkarest.entities.AbstractConfig;
import io.confluent.kafkarest.entities.TopicConfig;
import io.confluent.kafkarest.entities.v3.ListTopicConfigsResponse;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.entities.v3.TopicConfigDataList;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.resources.v3.TopicConfigsResource;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Path(value="/v3/clusters/{clusterId}/topics/{topicName}/default-configs")
@ResourceAccesslistFeature.ResourceName(value="api.v3.topic-configs.*")
public final class DefaultTopicConfigsResource {
    private final Provider<DefaultTopicConfigManager> defaultTopicConfigManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public DefaultTopicConfigsResource(Provider<DefaultTopicConfigManager> defaultTopicConfigManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.defaultTopicConfigManager = Objects.requireNonNull(defaultTopicConfigManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.configs.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topic-configs.list")
    public void listDefaultTopicConfigs(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName) {
        CompletionStage response = ((DefaultTopicConfigManager)this.defaultTopicConfigManager.get()).listDefaultTopicConfigs(clusterId, topicName).thenApply(configs -> ListTopicConfigsResponse.create((TopicConfigDataList)((TopicConfigDataList)((TopicConfigDataList.Builder)((TopicConfigDataList.Builder)TopicConfigDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "topics", topicName, "default-configs"})).build())).setData(configs.stream().sorted(Comparator.comparing(AbstractConfig::getName)).map(topicConfig -> TopicConfigsResource.toTopicConfigData((TopicConfig)topicConfig, (CrnFactory)this.crnFactory, (UrlFactory)this.urlFactory)).collect(Collectors.toList()))).build())));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }
}

