/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ExtensionsBrokerManager;
import io.confluent.kafkarest.entities.BrokerRemoval;
import io.confluent.kafkarest.entities.BrokerTaskType;
import io.confluent.kafkarest.entities.v3.BrokerRemovalData;
import io.confluent.kafkarest.entities.v3.GetBrokerRemovalResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.UnregisterBrokerData;
import io.confluent.kafkarest.entities.v3.UnregisterBrokerResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Path(value="/v3/clusters/{clusterId}/brokers")
@ResourceAccesslistFeature.ResourceName(value="api.v3.brokers.*")
public final class ExtensionsBrokersResource {
    private final Provider<ExtensionsBrokerManager> extensionsBrokerManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public ExtensionsBrokersResource(Provider<ExtensionsBrokerManager> extensionsBrokerManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.extensionsBrokerManager = Objects.requireNonNull(extensionsBrokerManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @POST
    @Path(value="/{brokerId}:unregister")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.unregister")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.brokers.unregister")
    public void unregisterBroker(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") Integer brokerId) {
        CompletionStage response = ((ExtensionsBrokerManager)this.extensionsBrokerManager.get()).unregisterBroker(clusterId, brokerId).thenApply(result -> UnregisterBrokerResponse.create(UnregisterBrokerData.builder().setBrokerId(brokerId).setClusterId(clusterId).build()));
        AsyncResponses.AsyncResponseBuilder.from((Response.ResponseBuilder)Response.status((Response.Status)Response.Status.ACCEPTED)).entity((CompletableFuture)response).asyncResume(asyncResponse);
    }

    @DELETE
    @Path(value="/{brokerId}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.delete")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.brokers.delete")
    public void removeBroker(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") Integer brokerId, @QueryParam(value="should_shutdown") @DefaultValue(value="true") boolean shouldShutdown) {
        CompletionStage response = ((ExtensionsBrokerManager)this.extensionsBrokerManager.get()).removeBroker(clusterId, brokerId, shouldShutdown).thenApply(brokerRemoval -> GetBrokerRemovalResponse.create(ExtensionsBrokersResource.toBrokerRemovalData(this.urlFactory, this.crnFactory, brokerRemoval)));
        AsyncResponses.AsyncResponseBuilder.from((Response.ResponseBuilder)Response.status((Response.Status)Response.Status.ACCEPTED)).entity((CompletableFuture)response).asyncResume(asyncResponse);
    }

    static BrokerRemovalData toBrokerRemovalData(UrlFactory urlFactory, CrnFactory crnFactory, BrokerRemoval brokerRemoval) {
        return ((BrokerRemovalData.Builder)BrokerRemovalData.fromBrokerRemoval(brokerRemoval).setMetadata(Resource.Metadata.builder().setSelf(urlFactory.create(new String[]{"v3", "clusters", brokerRemoval.getClusterId(), "brokers", Integer.toString(brokerRemoval.getBrokerId())})).setResourceName(crnFactory.create(new String[]{"kafka", brokerRemoval.getClusterId(), "broker", Integer.toString(brokerRemoval.getBrokerId())})).build())).setBrokerTask(Resource.Relationship.create((String)urlFactory.create(new String[]{"v3", "clusters", brokerRemoval.getClusterId(), "brokers", Integer.toString(brokerRemoval.getBrokerId()), "tasks", BrokerTaskType.REMOVE_BROKER.getBrokerTaskType()}))).setBroker(Resource.Relationship.create((String)urlFactory.create(new String[]{"v3", "clusters", brokerRemoval.getClusterId(), "brokers", Integer.toString(brokerRemoval.getBrokerId())}))).build();
    }
}

