/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.LastProducedTimeManager;
import io.confluent.kafkarest.entities.v3.GetLastProducedTimeResponse;
import io.confluent.kafkarest.entities.v3.LastProducedTimeData;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Path(value="/v3/clusters/{clusterId}/topics/{topicName}/last-produced-time")
@ResourceAccesslistFeature.ResourceName(value="api.v3.last-produced-time.*")
public final class GetLastProducedTimeAction {
    private final Provider<LastProducedTimeManager> lastProducedTimeManager;
    private final UrlFactory urlFactory;

    @Inject
    public GetLastProducedTimeAction(Provider<LastProducedTimeManager> lastProducedTimeManager, UrlFactory urlFactory) {
        this.lastProducedTimeManager = Objects.requireNonNull(lastProducedTimeManager);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.last-produced-time")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topics.last-produced-time")
    public void getLastProducedTime(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName) {
        CompletionStage response = ((LastProducedTimeManager)this.lastProducedTimeManager.get()).getLastProducedTime(clusterId, topicName).thenApply(lastProducedTime -> GetLastProducedTimeResponse.create(((LastProducedTimeData.Builder)LastProducedTimeData.fromProducedTime(lastProducedTime).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "topics", topicName, "last-produced-time"})).build())).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }
}

