/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.LinkConfigManager;
import io.confluent.kafkarest.entities.AbstractConfig;
import io.confluent.kafkarest.entities.LinkConfig;
import io.confluent.kafkarest.entities.v3.GetLinkConfigResponse;
import io.confluent.kafkarest.entities.v3.LinkConfigData;
import io.confluent.kafkarest.entities.v3.LinkConfigDataList;
import io.confluent.kafkarest.entities.v3.ListLinkConfigsResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.entities.v3.UpdateLinkConfigRequest;
import io.confluent.kafkarest.exceptions.InvalidConfigNameException;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.resources.v3.LinkResource;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.validation.Valid;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v3/clusters/{clusterId}/links/{linkName}/configs")
@ResourceAccesslistFeature.ResourceName(value="api.v3.link-configs.*")
public final class LinkConfigResource {
    private static final Logger log = LoggerFactory.getLogger(LinkResource.class);
    private final Provider<LinkConfigManager> linkConfigManager;
    private final UrlFactory urlFactory;

    @Inject
    public LinkConfigResource(Provider<LinkConfigManager> linkConfigManager, UrlFactory urlFactory) {
        this.linkConfigManager = Objects.requireNonNull(linkConfigManager);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.link-configs.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.link-configs.list")
    public void listLinkConfigs(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName) {
        CompletionStage response = ((LinkConfigManager)this.linkConfigManager.get()).listLinkConfigs(clusterId, linkName).thenApply(configs -> ListLinkConfigsResponse.create((LinkConfigDataList)((LinkConfigDataList.Builder)((LinkConfigDataList.Builder)LinkConfigDataList.builder().setData(configs.stream().sorted(Comparator.comparing(AbstractConfig::getName)).map(this::toLinkConfigData).collect(Collectors.toList()))).setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "links", linkName, "configs"})).build())).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    @GET
    @Path(value="/{configName}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.link-configs.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.link-configs.get")
    public void getLinkConfig(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName, @PathParam(value="configName") String configName) {
        CompletionStage response = ((CompletableFuture)((LinkConfigManager)this.linkConfigManager.get()).getLinkConfig(clusterId, linkName, configName).thenApply(linkConfig -> (LinkConfig)((Object)((Object)linkConfig.orElseThrow(() -> new InvalidConfigNameException(configName)))))).thenApply(linkConfig -> GetLinkConfigResponse.create(this.toLinkConfigData((LinkConfig)((Object)linkConfig))));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    private LinkConfigData toLinkConfigData(LinkConfig linkConfig) {
        return ((LinkConfigData.Builder)LinkConfigData.fromLinkConfig(linkConfig).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", linkConfig.getClusterId(), "links", linkConfig.getLinkName(), "configs", linkConfig.getName()})).build())).build();
    }

    @PUT
    @Path(value="/{configName}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.link-configs.update")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.link-configs.update")
    public void updateLinkConfig(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName, @PathParam(value="configName") String configName, @Valid UpdateLinkConfigRequest request) {
        String newValue = request.getValue().orElse(null);
        CompletableFuture<Void> response = ((LinkConfigManager)this.linkConfigManager.get()).updateLinkConfig(clusterId, linkName, configName, newValue);
        AsyncResponses.AsyncResponseBuilder.from((Response.ResponseBuilder)Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }

    @DELETE
    @Path(value="/{configName}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.link-configs.delete")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.link-configs.delete")
    public void resetLinkConfig(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName, @PathParam(value="configName") String configName) {
        CompletableFuture<Void> response = ((LinkConfigManager)this.linkConfigManager.get()).resetLinkConfig(clusterId, linkName, configName);
        AsyncResponses.AsyncResponseBuilder.from((Response.ResponseBuilder)Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }
}

