/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.LastProducedTimeManager;
import io.confluent.kafkarest.entities.v3.LastProducedTimeData;
import io.confluent.kafkarest.entities.v3.LastProducedTimeDataList;
import io.confluent.kafkarest.entities.v3.ListLastProducedTimesResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Path(value="/v3/clusters/{clusterId}/topics/-/last-produced-time")
@ResourceAccesslistFeature.ResourceName(value="api.v3.last-produced-time.*")
public final class ListAllLastProducedTimesAction {
    private final Provider<LastProducedTimeManager> lastProducedTimeManager;
    private final UrlFactory urlFactory;

    @Inject
    public ListAllLastProducedTimesAction(Provider<LastProducedTimeManager> lastProducedTimeManager, UrlFactory urlFactory) {
        this.lastProducedTimeManager = Objects.requireNonNull(lastProducedTimeManager);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.last-produced-time.list-all")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topics.last-produced-time.list-all")
    public void listAllLastProducedTimes(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId) {
        CompletionStage response = ((LastProducedTimeManager)this.lastProducedTimeManager.get()).listLastProducedTimes(clusterId).thenApply(lastProducedTimeList -> ListLastProducedTimesResponse.create((LastProducedTimeDataList)((LastProducedTimeDataList.Builder)((LastProducedTimeDataList.Builder)LastProducedTimeDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "topics", "-", "last-produced-time"})).build())).setData(lastProducedTimeList.stream().map(lastProducedTime -> ((LastProducedTimeData.Builder)LastProducedTimeData.fromProducedTime(lastProducedTime).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "topics", lastProducedTime.getTopicName(), "last-produced-time"})).build())).build()).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }
}

