/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.MirrorManager;
import io.confluent.kafkarest.entities.MirrorStatus;
import io.confluent.kafkarest.entities.v3.ListMirrorsResponse;
import io.confluent.kafkarest.entities.v3.MirrorDataList;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.UrlFactory;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v3/clusters/{clusterId}/links/-/mirrors")
@ResourceAccesslistFeature.ResourceName(value="api.v3.mirrors.*")
public final class ListAllMirrorsAction {
    private static final Logger log = LoggerFactory.getLogger(ListAllMirrorsAction.class);
    private final Provider<MirrorManager> mirrorManager;
    private final UrlFactory urlFactory;

    @Inject
    public ListAllMirrorsAction(Provider<MirrorManager> mirrorManager, UrlFactory urlFactory) {
        this.mirrorManager = Objects.requireNonNull(mirrorManager);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.mirrors.list-all")
    public void listAllMirrors(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @QueryParam(value="mirror_status") String mirrorStatus) {
        String mirrorResourceUrl = this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "links", "-", "mirrors"});
        CompletionStage response = ((MirrorManager)this.mirrorManager.get()).listMirrors(clusterId, MirrorStatus.fromString(mirrorStatus)).thenApply(mirrors -> ListMirrorsResponse.create((MirrorDataList)MirrorDataList.builder(mirrorResourceUrl, mirrors).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }
}

