/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.MirrorManager;
import io.confluent.kafkarest.entities.Mirror;
import io.confluent.kafkarest.entities.MirrorStatus;
import io.confluent.kafkarest.entities.v3.CreateMirrorRequest;
import io.confluent.kafkarest.entities.v3.CreateTopicRequest;
import io.confluent.kafkarest.entities.v3.GetMirrorResponse;
import io.confluent.kafkarest.entities.v3.ListMirrorsResponse;
import io.confluent.kafkarest.entities.v3.MirrorData;
import io.confluent.kafkarest.entities.v3.MirrorDataList;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.exceptions.MirrorTopicNotFoundException;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v3/clusters/{clusterId}/links/{linkName}/mirrors")
@ResourceAccesslistFeature.ResourceName(value="api.v3.mirrors.*")
public final class MirrorResource {
    private static final Logger log = LoggerFactory.getLogger(MirrorResource.class);
    private final Provider<MirrorManager> mirrorManager;
    private final UrlFactory urlFactory;

    @Inject
    public MirrorResource(Provider<MirrorManager> mirrorManager, UrlFactory urlFactory) {
        this.mirrorManager = Objects.requireNonNull(mirrorManager);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.mirrors.create")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.mirrors.create")
    public void createMirror(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName, @Valid CreateMirrorRequest request) {
        String sourceTopicName = request.getSourceTopicName();
        String mirrorTopicName = request.getMirrorTopicName();
        Optional<Short> replicationFactor = request.getReplicationFactor();
        Map<String, Optional<String>> configs = request.getConfigs().stream().collect(Collectors.toMap(CreateTopicRequest.ConfigEntry::getName, CreateTopicRequest.ConfigEntry::getValue));
        CompletableFuture<Void> response = ((MirrorManager)this.mirrorManager.get()).createMirror(clusterId, linkName, sourceTopicName, mirrorTopicName, configs, replicationFactor);
        AsyncResponses.AsyncResponseBuilder.from((Response.ResponseBuilder)Response.status((Response.Status)Response.Status.CREATED)).entity(response).asyncResume(asyncResponse);
    }

    @GET
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.mirrors.list")
    public void listMirrors(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName, @QueryParam(value="mirror_status") MirrorStatus mirrorStatus) {
        String mirrorResourceUrl = this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "links", linkName, "mirrors"});
        CompletionStage response = ((MirrorManager)this.mirrorManager.get()).listMirrors(clusterId, linkName, mirrorStatus).thenApply(mirrors -> ListMirrorsResponse.create((MirrorDataList)MirrorDataList.builder(mirrorResourceUrl, mirrors).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }

    @GET
    @Path(value="/{mirrorTopicName}")
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.mirrors.get")
    public void getMirror(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName, @PathParam(value="mirrorTopicName") String mirrorTopicName, @QueryParam(value="include_state_transition_errors") Boolean includeStateTransitionErrors) {
        CompletionStage response = ((MirrorManager)this.mirrorManager.get()).getMirror(clusterId, linkName, mirrorTopicName, includeStateTransitionErrors).thenApply(mirrorOptional -> {
            Mirror mirror = (Mirror)mirrorOptional.orElseThrow(() -> new MirrorTopicNotFoundException(mirrorTopicName));
            return GetMirrorResponse.create(((MirrorData.Builder)MirrorData.fromMirror(mirror).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "links", linkName, "mirrors", mirror.getMirrorTopicName()})).build())).build());
        });
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }
}

