/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.ReplicaStatusManager;
import io.confluent.kafkarest.entities.v3.ListReplicaStatusResponse;
import io.confluent.kafkarest.entities.v3.ReplicaStatusData;
import io.confluent.kafkarest.entities.v3.ReplicaStatusDataList;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

@Path(value="/v3/clusters/{clusterId}/topics/{topicName}/partitions/-/replica-status")
@ResourceAccesslistFeature.ResourceName(value="api.v3.replica-statuses.*")
public final class ReplicaStatusResource {
    private final Provider<ReplicaStatusManager> replicaStatusManager;
    private final UrlFactory urlFactory;

    @Inject
    public ReplicaStatusResource(Provider<ReplicaStatusManager> replicaStatusManager, UrlFactory urlFactory) {
        this.replicaStatusManager = Objects.requireNonNull(replicaStatusManager);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.topics.replica-statuses.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.topics.replica-statuses.list")
    public void listReplicaStatus(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName) {
        CompletionStage response = ((ReplicaStatusManager)this.replicaStatusManager.get()).listTopicReplicaStatus(clusterId, topicName).thenApply(replicaStatusList -> ListReplicaStatusResponse.create((ReplicaStatusDataList)((ReplicaStatusDataList.Builder)((ReplicaStatusDataList.Builder)ReplicaStatusDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", clusterId, "topics", topicName, "replica-status"})).build())).setData(replicaStatusList.stream().map(replicaStatus -> ((ReplicaStatusData.Builder)ReplicaStatusData.fromReplicaStatus(replicaStatus).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.create(new String[]{"v3", "clusters", replicaStatus.getClusterId(), "topics", replicaStatus.getTopicName(), "partitions", String.valueOf(replicaStatus.getPartitionId()), "brokers", String.valueOf(replicaStatus.getBrokerId()), "replica-status"})).build())).build()).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)response);
    }
}

