/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.SimpleConsumeManager;
import io.confluent.kafkarest.controllers.TopicManager;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.Topic;
import io.confluent.kafkarest.entities.v3.PartitionConsumeData;
import io.confluent.kafkarest.entities.v3.SimpleConsumeMultiPartitionRequest;
import io.confluent.kafkarest.entities.v3.SimpleConsumeMultiPartitionResponse;
import io.confluent.kafkarest.entities.v3.SimpleConsumeOffsetsMultiPartitionResponse;
import io.confluent.kafkarest.entities.v3.SimpleConsumeOffsetsSinglePartitionResponse;
import io.confluent.kafkarest.entities.v3.SimpleConsumeSinglePartitionResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.validation.Valid;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;

@Path(value="/v3/clusters/{clusterId}/internal/topics/{topicName}")
@ResourceAccesslistFeature.ResourceName(value="api.v3.simple-consume.*")
public final class SimpleConsumeAction {
    public static final int MAX_POLL_RECORDS_LIMIT = 2000;
    public static final String ERROR_MESSAGE_MAX_BYTES_CANNOT_BE_NEGATIVE = "message_max_bytes cannot be negative.";
    private final Provider<TopicManager> topicManager;
    private final Provider<SimpleConsumeManager> simpleConsumeManager;

    @Inject
    public SimpleConsumeAction(Provider<TopicManager> topicManager, Provider<SimpleConsumeManager> simpleConsumeManager) {
        this.topicManager = Objects.requireNonNull(topicManager);
        this.simpleConsumeManager = Objects.requireNonNull(simpleConsumeManager);
    }

    @GET
    @Path(value="/partitions/{partitionId}/records")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.simple-consume.1-partition")
    @PerformanceMetric(value="v3.simple-consume.1-partition")
    public void consumeFromPartition(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @PathParam(value="partitionId") Integer partitionId, @QueryParam(value="from_beginning") String fromBeginningParam, @QueryParam(value="offset") String offsetParam, @QueryParam(value="timestamp") String timestampParam, @QueryParam(value="max_poll_records") Integer maxPollRecords, @QueryParam(value="fetch_max_bytes") Integer fetchMaxBytes, @QueryParam(value="message_max_bytes") Integer messageMaxBytes) {
        if (messageMaxBytes != null && messageMaxBytes < 0) {
            throw new BadRequestException(ERROR_MESSAGE_MAX_BYTES_CANNOT_BE_NEGATIVE);
        }
        if (maxPollRecords != null && maxPollRecords > 2000) {
            throw new BadRequestException(String.format("max_poll_records cannot exceed the value of %d.", 2000));
        }
        int positionCriteriaCount = SimpleConsumeAction.getPositionCriteriaCountConsumeFromPartition(fromBeginningParam, offsetParam, timestampParam);
        if (positionCriteriaCount > 1) {
            throw new BadRequestException("At most one of 'offset', 'from_beginning' or 'timestamp' should be provided.");
        }
        Boolean fromBeginning = positionCriteriaCount == 0 ? Boolean.FALSE : SimpleConsumeAction.validateBooleanQueryParameter(fromBeginningParam);
        Long offset = SimpleConsumeAction.validateLongQueryParameter(offsetParam, "offset");
        Long timestamp = SimpleConsumeAction.validateLongQueryParameter(timestampParam, "timestamp");
        SimpleConsumeManager manager = (SimpleConsumeManager)this.simpleConsumeManager.get();
        CompletionStage responseFuture = ((CompletableFuture)this.checkClusterTopicExist(clusterId, topicName).thenCompose(topic -> {
            SimpleConsumeAction.validatePartitions(Collections.singleton(partitionId), (List<Partition>)topic.getPartitions());
            TopicPartition partition = new TopicPartition(topicName, partitionId.intValue());
            return manager.consumeFromPartition(partition, fromBeginning, timestamp, offset, maxPollRecords, fetchMaxBytes, messageMaxBytes);
        })).thenApply(singlePartitionRecords -> SimpleConsumeSinglePartitionResponse.builder().setClusterId(clusterId).setTopicName(topicName).setPartitionData((PartitionConsumeData)singlePartitionRecords).build());
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)responseFuture);
    }

    @POST
    @Path(value="/partitions/-/records:consume")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.simple-consume.n-partitions")
    @PerformanceMetric(value="v3.simple-consume.n-partitions")
    public void consumeFromPartitions(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @Valid SimpleConsumeMultiPartitionRequest request) {
        CompletableFuture<SimpleConsumeMultiPartitionResponse> responseFuture = this.doConsumeFromPartitions(clusterId, topicName, request, false);
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, responseFuture);
    }

    @POST
    @Path(value="/partitions/-/records:consume_guarantee_progress")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.simple-consume.n-partitions-guarantee-progress")
    @PerformanceMetric(value="v3.simple-consume.n-partitions-guarantee-progress")
    public void consumeFromPartitionsGuaranteeProgress(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @Valid SimpleConsumeMultiPartitionRequest request) {
        CompletableFuture<SimpleConsumeMultiPartitionResponse> responseFuture = this.doConsumeFromPartitions(clusterId, topicName, request, true);
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, responseFuture);
    }

    private CompletableFuture<SimpleConsumeMultiPartitionResponse> doConsumeFromPartitions(String clusterId, String topicName, SimpleConsumeMultiPartitionRequest request, boolean guaranteeProgressForEachPartition) {
        if (request == null) {
            throw Errors.invalidPayloadException((String)"Null input provided. Data is required.");
        }
        if (request.getMessageMaxBytes() != null && request.getMessageMaxBytes() < 0) {
            throw new BadRequestException(ERROR_MESSAGE_MAX_BYTES_CANNOT_BE_NEGATIVE);
        }
        if (request.getMaxPollRecords() != null && request.getMaxPollRecords() > 2000) {
            throw new BadRequestException(String.format("max_poll_records cannot exceed the value of %d.", 2000));
        }
        if (!SimpleConsumeAction.getPositionCriteriaCountFromMultiPartitionRequest(request)) {
            throw new BadRequestException("At most one of 'offsets', 'from_beginning' or 'timestamp' should be provided.");
        }
        if (!SimpleConsumeAction.checkOffsetsInMultiPartitionRequest(request)) {
            throw new BadRequestException("Offset must not be a negative number.");
        }
        SimpleConsumeManager manager = (SimpleConsumeManager)this.simpleConsumeManager.get();
        return ((CompletableFuture)this.checkClusterTopicExist(clusterId, topicName).thenCompose(topic -> {
            List<SimpleConsumeMultiPartitionRequest.PartitionOffset> offsetsList = request.getOffsets();
            Map<Integer, Long> offsets = offsetsList != null ? offsetsList.stream().collect(Collectors.toMap(SimpleConsumeMultiPartitionRequest.PartitionOffset::getPartitionId, SimpleConsumeMultiPartitionRequest.PartitionOffset::getOffset)) : null;
            ImmutableList partitions = topic.getPartitions();
            if (offsets != null) {
                SimpleConsumeAction.validatePartitions(offsets.keySet(), (List<Partition>)partitions);
            }
            return manager.consumeFromMultiplePartitions(topicName, partitions.size(), offsets, request.getFromBeginning(), request.getTimestamp(), request.getMaxPollRecords(), request.getFetchMaxBytes(), request.getMessageMaxBytes(), guaranteeProgressForEachPartition);
        })).thenApply(multiPartitionRecords -> SimpleConsumeMultiPartitionResponse.builder().setClusterId(clusterId).setTopicName(topicName).setPartitionDataList((List<PartitionConsumeData>)multiPartitionRecords).build());
    }

    @GET
    @Path(value="/partitions/{partitionId}/records:offsets")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.simple-consume.offsets-1-partition")
    @PerformanceMetric(value="v3.simple-consume.offsets-1-partition")
    public void getOffsetsForPartition(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @PathParam(value="partitionId") Integer partitionId, @QueryParam(value="from_beginning") String fromBeginningParam, @QueryParam(value="timestamp") String timestampParam) {
        int positionCriteriaCount = 0;
        if (fromBeginningParam != null) {
            ++positionCriteriaCount;
        }
        if (timestampParam != null) {
            ++positionCriteriaCount;
        }
        if (positionCriteriaCount > 1) {
            throw new BadRequestException("At most one of 'from_beginning' or 'timestamp' should be provided.");
        }
        Boolean fromBeginning = positionCriteriaCount == 0 ? Boolean.FALSE : SimpleConsumeAction.validateBooleanQueryParameter(fromBeginningParam);
        Long timestamp = SimpleConsumeAction.validateLongQueryParameter(timestampParam, "timestamp");
        SimpleConsumeManager manager = (SimpleConsumeManager)this.simpleConsumeManager.get();
        CompletionStage responseFuture = ((CompletableFuture)this.checkClusterTopicExist(clusterId, topicName).thenCompose(topic -> {
            SimpleConsumeAction.validatePartitions(Collections.singleton(partitionId), (List<Partition>)topic.getPartitions());
            TopicPartition partition = new TopicPartition(topicName, partitionId.intValue());
            return manager.getOffsetForPartition(partition, fromBeginning, timestamp);
        })).thenApply(nextOffset -> SimpleConsumeOffsetsSinglePartitionResponse.builder().setClusterId(clusterId).setTopicName(topicName).setPartitionId(partitionId).setNextOffset((Long)nextOffset).build());
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)responseFuture);
    }

    @GET
    @Path(value="/partitions/-/records:offsets")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.simple-consume.offsets-n-partitions")
    @PerformanceMetric(value="v3.simple-consume.offsets-n-partitions")
    public void getOffsetsForPartitions(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="topicName") String topicName, @QueryParam(value="from_beginning") String fromBeginningParam, @QueryParam(value="timestamp") String timestampParam) {
        int positionCriteriaCount = 0;
        if (fromBeginningParam != null) {
            ++positionCriteriaCount;
        }
        if (timestampParam != null) {
            ++positionCriteriaCount;
        }
        if (positionCriteriaCount > 1) {
            throw new BadRequestException("At most one of 'from_beginning' or 'timestamp' should be provided.");
        }
        Boolean fromBeginning = positionCriteriaCount == 0 ? Boolean.FALSE : SimpleConsumeAction.validateBooleanQueryParameter(fromBeginningParam);
        Long timestamp = SimpleConsumeAction.validateLongQueryParameter(timestampParam, "timestamp");
        SimpleConsumeManager manager = (SimpleConsumeManager)this.simpleConsumeManager.get();
        CompletionStage responseFuture = ((CompletableFuture)this.checkClusterTopicExist(clusterId, topicName).thenCompose(topic -> {
            ImmutableList partitions = topic.getPartitions();
            return manager.getOffsetsForPartitions(topicName, partitions.size(), fromBeginning, timestamp);
        })).thenApply(partitionsOffsetsData -> SimpleConsumeOffsetsMultiPartitionResponse.builder().setClusterId(clusterId).setTopicName(topicName).setPartitionOffsetList(partitionsOffsetsData.getOffsetsList()).setTotalRecords(partitionsOffsetsData.getTotalRecords()).build());
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, (CompletableFuture)responseFuture);
    }

    private CompletableFuture<Topic> checkClusterTopicExist(String clusterId, String topicName) {
        return ((TopicManager)this.topicManager.get()).getTopic(clusterId, topicName).thenApply(topic -> (Topic)topic.orElseThrow(Errors::topicNotFoundException));
    }

    private static void validatePartitions(@Nonnull Set<Integer> requested, @Nonnull List<Partition> available) {
        Map<Integer, Partition> availableById = available.stream().collect(Collectors.toMap(Partition::getPartitionId, p -> p));
        for (int requestedId : requested) {
            if (availableById.containsKey(requestedId)) continue;
            throw new BadRequestException("Cannot find partition with ID " + requestedId);
        }
    }

    private static Long validateLongQueryParameter(String paramValue, String paramName) {
        if (paramValue != null) {
            try {
                Long value = Long.valueOf(paramValue);
                if (value < 0L) {
                    throw new BadRequestException("'" + paramName + "' must not be a negative number");
                }
                return value;
            }
            catch (NumberFormatException nfe) {
                throw new BadRequestException("'" + paramName + "' must be numeric");
            }
        }
        return null;
    }

    private static boolean getPositionCriteriaCountFromMultiPartitionRequest(SimpleConsumeMultiPartitionRequest request) {
        int positionCriteriaCount = 0;
        positionCriteriaCount += request.getOffsets() != null ? 1 : 0;
        positionCriteriaCount += request.getFromBeginning() != null ? 1 : 0;
        return (positionCriteriaCount += request.getTimestamp() != null ? 1 : 0) <= 1;
    }

    private static boolean checkOffsetsInMultiPartitionRequest(SimpleConsumeMultiPartitionRequest request) {
        if (request.getOffsets() != null) {
            List<SimpleConsumeMultiPartitionRequest.PartitionOffset> offsets = request.getOffsets();
            for (SimpleConsumeMultiPartitionRequest.PartitionOffset offset : offsets) {
                if (offset.getOffset() >= 0L) continue;
                return false;
            }
        }
        return true;
    }

    private static int getPositionCriteriaCountConsumeFromPartition(String fromBeginningParam, String offsetParam, String timestampParam) {
        int positionCriteriaCount = 0;
        positionCriteriaCount += fromBeginningParam != null ? 1 : 0;
        positionCriteriaCount += offsetParam != null ? 1 : 0;
        return positionCriteriaCount += timestampParam != null ? 1 : 0;
    }

    private static Boolean validateBooleanQueryParameter(String paramValue) {
        if (paramValue != null) {
            return Boolean.valueOf(paramValue);
        }
        return null;
    }
}

