/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.MirrorManager;
import io.confluent.kafkarest.entities.v3.AlterMirrorsRequest;
import io.confluent.kafkarest.entities.v3.AlterMirrorsResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.kafkarest.utils.AlterMirrorHelper;
import io.confluent.rest.annotations.PerformanceMetric;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v3/clusters/{clusterId}/links/{linkName}/mirrors:truncate-and-restore")
@ResourceAccesslistFeature.ResourceName(value="api.v3.mirrors.*")
public final class TruncateAndRestoreMirrorAction {
    private static final Logger log = LoggerFactory.getLogger(TruncateAndRestoreMirrorAction.class);
    private final Provider<MirrorManager> mirrorManager;
    private final UrlFactory urlFactory;

    @Inject
    public TruncateAndRestoreMirrorAction(Provider<MirrorManager> mirrorManager, UrlFactory urlFactory) {
        this.mirrorManager = Objects.requireNonNull(mirrorManager);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceAccesslistFeature.ResourceName(value="api.v3.mirrors.truncate-and-restore")
    @PerformanceMetric(value="v3.mirrors.truncate-and-restore")
    public void truncateAndRestoreMirrorAction(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="linkName") String linkName, @QueryParam(value="validate_only") boolean validateOnly, @QueryParam(value="include_partition_level_truncation_data") boolean includePartitionLevelTruncationData, @Valid AlterMirrorsRequest request) {
        CompletableFuture<AlterMirrorsResponse> response = AlterMirrorHelper.alterMirrors(this.urlFactory, clusterId, linkName, () -> ((MirrorManager)this.mirrorManager.get()).truncateAndRestoreMirrors(clusterId, linkName, (Set<String>)request.getMirrorTopicNames(), request.getMirrorTopicNamePattern(), includePartitionLevelTruncationData, validateOnly));
        AsyncResponses.asyncResume((AsyncResponse)asyncResponse, response);
    }
}

