/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer;

import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizeRequest;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaNotFoundAuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import jakarta.ws.rs.core.UriInfo;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaRegistryAuthorizer
implements SchemaRegistryAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaRegistryAuthorizer.class);
    private SchemaRegistry schemaRegistry;

    @Override
    public void configure(SchemaRegistryConfig config, SchemaRegistry schemaRegistry) throws AuthorizerException {
        this.schemaRegistry = schemaRegistry;
    }

    protected SchemaRegistry schemaRegistry() {
        return this.schemaRegistry;
    }

    @Override
    public final SchemaRegistryAuthorizer.AuthorizerResult authorize(AuthorizeRequest authorizeRequest) throws AuthorizerException {
        SchemaRegistryResourceOperation schemaRegistryResourceOperation = authorizeRequest.getSchemaRegistryResourceOperation();
        Principal principal = authorizeRequest.getUser();
        String user = principal.getName();
        if (SchemaRegistryResourceOperation.SCHEMA_READ.equals((Object)schemaRegistryResourceOperation)) {
            String subject = authorizeRequest.getResourceName();
            SchemaRegistryAuthorizer.AuthorizerResult result = this.authorizeSchemaIdLookup(principal, authorizeRequest);
            log.debug("Authorization of schema ID lookup {} for user {} and subject {}", new Object[]{result.toString(), user != null ? user : "N/A", subject != null ? subject : "N/A"});
            return result;
        }
        if (SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS.contains((Object)schemaRegistryResourceOperation)) {
            String subject = authorizeRequest.getResourceName();
            return this.authorizeSubjectOperation(user, subject, schemaRegistryResourceOperation, authorizeRequest);
        }
        if (SchemaRegistryResourceOperation.KEK_RESOURCE_OPERATIONS.contains((Object)schemaRegistryResourceOperation)) {
            String kekName = authorizeRequest.getResourceName();
            return this.authorizeKekOperation(user, kekName, schemaRegistryResourceOperation, authorizeRequest);
        }
        if (SchemaRegistryResourceOperation.GLOBAL_RESOURCE_OPERATIONS.contains((Object)schemaRegistryResourceOperation)) {
            return this.authorizeGlobalOperation(user, schemaRegistryResourceOperation, authorizeRequest);
        }
        if (SchemaRegistryResourceOperation.EXPORTER_ACCESS.equals((Object)schemaRegistryResourceOperation)) {
            return this.authorizeExporterOperation(principal, authorizeRequest);
        }
        return SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
    }

    @Override
    public void shutdown() {
    }

    public abstract SchemaRegistryAuthorizer.AuthorizerResult authorizeGlobalOperation(String var1, SchemaRegistryResourceOperation var2, AuthorizeRequest var3);

    public abstract SchemaRegistryAuthorizer.AuthorizerResult authorizeSubjectOperation(String var1, String var2, SchemaRegistryResourceOperation var3, AuthorizeRequest var4);

    public abstract SchemaRegistryAuthorizer.AuthorizerResult authorizeKekOperation(String var1, String var2, SchemaRegistryResourceOperation var3, AuthorizeRequest var4);

    private final SchemaRegistryAuthorizer.AuthorizerResult authorizeExporterOperation(Principal principal, AuthorizeRequest authorizeRequest) throws AuthorizerException {
        ArrayList<AuthorizeRequest> requests = new ArrayList<AuthorizeRequest>();
        for (SchemaRegistryResourceOperation operation : SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS) {
            requests.add(new AuthorizeRequest(authorizeRequest.getUser(), "*", operation, authorizeRequest.getContainerRequestContext(), authorizeRequest.getHttpServletRequest()));
        }
        return this.bulkAuthorize(principal, requests).stream().allMatch(SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED::equals) ? SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED : SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
    }

    public final SchemaRegistryAuthorizer.AuthorizerResult authorizeSchemaIdLookup(Principal principal, AuthorizeRequest authorizeRequest) throws AuthorizerException {
        Set subjects;
        UriInfo uriInfo = authorizeRequest.getContainerRequestContext().getUriInfo();
        if ("schemas/types".equals(uriInfo.getPath())) {
            return SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED;
        }
        String schemaId = (String)uriInfo.getPathParameters().getFirst((Object)"id");
        String subjectParam = (String)uriInfo.getQueryParameters().getFirst((Object)"subject");
        try {
            subjects = this.schemaRegistry.listSubjectsForId(Integer.parseInt(schemaId), subjectParam, true);
            if (subjects == null || subjects.isEmpty()) {
                throw new SchemaNotFoundAuthorizerException("schema subject not found for id=" + schemaId);
            }
        }
        catch (SchemaRegistryException | NumberFormatException e) {
            log.warn("Failed to lookup schemaId {} under subject {}", (Object)schemaId, (Object)subjectParam);
            return SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
        }
        List<AuthorizeRequest> authorizeRequests = subjects.stream().flatMap(subject -> this.subjectReadRequest((String)subject, authorizeRequest)).collect(Collectors.toList());
        return this.bulkAuthorize(principal, authorizeRequests).stream().anyMatch(SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED::equals) ? SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED : SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
    }

    public String getAuthorizationSubject(String subject) {
        return subject;
    }

    protected Stream<AuthorizeRequest> subjectReadRequest(String subject, AuthorizeRequest original) {
        ArrayList<AuthorizeRequest> requests = new ArrayList<AuthorizeRequest>();
        requests.add(new AuthorizeRequest(original.getUser(), subject, SchemaRegistryResourceOperation.SUBJECT_READ, original.getContainerRequestContext(), original.getHttpServletRequest()));
        QualifiedSubject qs = QualifiedSubject.create((String)this.schemaRegistry().tenant(), (String)subject);
        String context = qs.getContext();
        if (!".".equals(context)) {
            String normalizedContext = QualifiedSubject.normalizeContext((String)context);
            requests.add(new AuthorizeRequest(original.getUser(), normalizedContext, SchemaRegistryResourceOperation.SUBJECT_READ, original.getContainerRequestContext(), original.getHttpServletRequest()));
        }
        return requests.stream();
    }
}

