/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.rbac;

import io.confluent.common.security.util.AuthorizerUtils;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.SchemaRegistrySecurityResourceExtension;
import io.confluent.kafka.schemaregistry.security.authorizer.AbstractSchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizeRequest;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.security.authorizer.rbac.SchemaRegistryActions;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.security.auth.client.RestAuthorizer;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Scope;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbacAuthorizer
extends AbstractSchemaRegistryAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(RbacAuthorizer.class);
    private RestAuthorizer restAuthorizer;
    private SchemaRegistryActions schemaRegistryActions;

    public RbacAuthorizer() {
    }

    RbacAuthorizer(SchemaRegistry schemaRegistry, RestAuthorizer restAuthorizer, SchemaRegistryActions schemaRegistryActions) throws AuthorizerException {
        super.configure(null, schemaRegistry);
        this.restAuthorizer = restAuthorizer;
        this.schemaRegistryActions = schemaRegistryActions;
    }

    @Override
    public void configure(SchemaRegistryConfig config, SchemaRegistry kafkaSchemaRegistry) throws AuthorizerException {
        super.configure(config, kafkaSchemaRegistry);
        this.restAuthorizer = new RestAuthorizer();
        this.restAuthorizer.configure(config.originals());
        Scope scope = SchemaRegistrySecurityResourceExtension.determineScope(kafkaSchemaRegistry);
        this.schemaRegistryActions = new SchemaRegistryActions(scope);
        log.info("Initialized RBAC authorizer on cluster with scope of '{}'", (Object)scope);
    }

    @Override
    public SchemaRegistryAuthorizer.AuthorizerResult authorizeGlobalOperation(String user, SchemaRegistryResourceOperation schemaRegistryResourceOperation, AuthorizeRequest originalAuthorizeRequest) {
        if (SchemaRegistryResourceOperation.GLOBAL_READ.equals((Object)schemaRegistryResourceOperation)) {
            return SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED;
        }
        return this.authorizeRequest(originalAuthorizeRequest.getUser(), this.schemaRegistryActions.globalAction(schemaRegistryResourceOperation));
    }

    @Override
    public SchemaRegistryAuthorizer.AuthorizerResult authorizeSubjectOperation(String user, String subject, SchemaRegistryResourceOperation schemaRegistryResourceOperation, AuthorizeRequest originalAuthorizeRequest) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.schemaRegistryActions.subjectAction(schemaRegistryResourceOperation, subject));
        QualifiedSubject qs = QualifiedSubject.create((String)this.schemaRegistry().tenant(), (String)subject);
        String context = qs.getContext();
        if (!".".equals(context)) {
            String normalizedContext = QualifiedSubject.normalizeContext((String)context);
            actions.add(this.schemaRegistryActions.subjectAction(schemaRegistryResourceOperation, normalizedContext));
        }
        return this.authorizeActions(originalAuthorizeRequest.getUser(), actions).stream().anyMatch(SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED::equals) ? SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED : SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
    }

    @Override
    public SchemaRegistryAuthorizer.AuthorizerResult authorizeKekOperation(String user, String kekName, SchemaRegistryResourceOperation schemaRegistryResourceOperation, AuthorizeRequest originalAuthorizeRequest) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.schemaRegistryActions.kekAction(schemaRegistryResourceOperation, kekName));
        return this.authorizeActions(originalAuthorizeRequest.getUser(), actions).stream().anyMatch(SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED::equals) ? SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED : SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
    }

    @Override
    public List<SchemaRegistryAuthorizer.AuthorizerResult> bulkAuthorize(Principal principal, List<AuthorizeRequest> authorizeRequests) {
        if (authorizeRequests.isEmpty()) {
            return Collections.singletonList(SchemaRegistryAuthorizer.AuthorizerResult.DENIED);
        }
        List<Action> actions = authorizeRequests.stream().map(this.schemaRegistryActions::action).collect(Collectors.toList());
        return this.authorizeActions(principal, actions);
    }

    @Override
    public void shutdown() {
        if (this.restAuthorizer != null) {
            try {
                this.restAuthorizer.close();
            }
            catch (IOException e) {
                log.error("Error while closing REST authorizer", (Throwable)e);
            }
            finally {
                this.restAuthorizer = null;
            }
        }
    }

    protected SchemaRegistryAuthorizer.AuthorizerResult authorizeRequest(Principal principal, Action action) {
        return this.authorizeActions(principal, Collections.singletonList(action)).stream().allMatch(result -> result == SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED) ? SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED : SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
    }

    protected List<SchemaRegistryAuthorizer.AuthorizerResult> authorizeActions(Principal principal, List<Action> actions) {
        log.info("Authorizing actions {} with principal {}", actions, (Object)principal);
        return this.restAuthorizer.authorize(AuthorizerUtils.kafkaPrincipalFor((Principal)principal), null, actions).stream().map(result -> result == AuthorizeResult.ALLOWED ? SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED : SchemaRegistryAuthorizer.AuthorizerResult.DENIED).collect(Collectors.toList());
    }
}

