/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.rbac;

import io.confluent.kafka.schemaregistry.rest.exceptions.RestSchemaRegistryException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SchemaRegistryOperations {
    public static final String GLOBAL_RESOURCE_NAME = "__GLOBAL";
    public static final ResourceType SUBJECT_RESOURCE = new ResourceType("Subject");
    public static final ResourceType KEK_RESOURCE = new ResourceType("Kek");
    public static final Operation READ = new Operation("Read");
    public static final Operation WRITE = new Operation("Write");
    public static final Operation UPDATE = new Operation("Update");
    public static final Operation REGISTER = new Operation("Register");
    public static final Operation DEREGISTER = new Operation("Deregister");
    public static final Operation DELETE = new Operation("Delete");
    public static final Operation READ_COMPATIBILITY = new Operation("ReadCompatibility");
    public static final Operation WRITE_COMPATIBILITY = new Operation("WriteCompatibility");
    private static final Map<SchemaRegistryResourceOperation, Operation> OPERATIONS_MAP;
    private static final Map<SchemaRegistryResourceOperation, ResourceType> RESOURCE_TYPE_MAP;

    private SchemaRegistryOperations() {
    }

    public static Operation operationFor(SchemaRegistryResourceOperation operation) {
        Operation result = OPERATIONS_MAP.get((Object)operation);
        if (result == null) {
            throw new RestSchemaRegistryException("Unrecognized schema registry resource operation " + String.valueOf((Object)operation));
        }
        return result;
    }

    public static ResourceType resourceTypeFor(SchemaRegistryResourceOperation operation) {
        ResourceType result = RESOURCE_TYPE_MAP.get((Object)operation);
        if (result == null) {
            throw new RestSchemaRegistryException("Unrecognized schema registry resource operation " + String.valueOf((Object)operation));
        }
        return result;
    }

    static {
        HashMap<SchemaRegistryResourceOperation, Operation> operationsMap = new HashMap<SchemaRegistryResourceOperation, Operation>();
        operationsMap.put(SchemaRegistryResourceOperation.SUBJECT_READ, READ);
        operationsMap.put(SchemaRegistryResourceOperation.SUBJECT_WRITE, WRITE);
        operationsMap.put(SchemaRegistryResourceOperation.SUBJECT_DELETE, DELETE);
        operationsMap.put(SchemaRegistryResourceOperation.KEK_READ, READ);
        operationsMap.put(SchemaRegistryResourceOperation.KEK_REGISTER, REGISTER);
        operationsMap.put(SchemaRegistryResourceOperation.KEK_UPDATE, UPDATE);
        operationsMap.put(SchemaRegistryResourceOperation.KEK_DEREGISTER, DEREGISTER);
        List<SchemaRegistryResourceOperation> readCompatibilityOperations = Arrays.asList(SchemaRegistryResourceOperation.GLOBAL_COMPATIBILITY_READ, SchemaRegistryResourceOperation.SUBJECT_COMPATIBILITY_READ);
        for (SchemaRegistryResourceOperation readCompatibilityOperation : readCompatibilityOperations) {
            operationsMap.put(readCompatibilityOperation, READ_COMPATIBILITY);
        }
        List<SchemaRegistryResourceOperation> writeCompatibilityOperations = Arrays.asList(SchemaRegistryResourceOperation.GLOBAL_COMPATIBILITY_WRITE, SchemaRegistryResourceOperation.SUBJECT_COMPATIBILITY_WRITE);
        for (SchemaRegistryResourceOperation writeCompatibility : writeCompatibilityOperations) {
            operationsMap.put(writeCompatibility, WRITE_COMPATIBILITY);
        }
        OPERATIONS_MAP = Collections.unmodifiableMap(operationsMap);
        HashMap<SchemaRegistryResourceOperation, ResourceType> resourceTypeMap = new HashMap<SchemaRegistryResourceOperation, ResourceType>();
        for (SchemaRegistryResourceOperation subjectOperation : SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS) {
            resourceTypeMap.put(subjectOperation, SUBJECT_RESOURCE);
        }
        for (SchemaRegistryResourceOperation kekOperation : SchemaRegistryResourceOperation.KEK_RESOURCE_OPERATIONS) {
            resourceTypeMap.put(kekOperation, KEK_RESOURCE);
        }
        for (SchemaRegistryResourceOperation subjectOperation : SchemaRegistryResourceOperation.GLOBAL_RESOURCE_OPERATIONS) {
            if (SchemaRegistryResourceOperation.GLOBAL_READ.equals((Object)subjectOperation)) continue;
            resourceTypeMap.put(subjectOperation, SUBJECT_RESOURCE);
        }
        RESOURCE_TYPE_MAP = Collections.unmodifiableMap(resourceTypeMap);
    }
}

