/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.authorizer.AbstractSchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizeRequest;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.AclMessageSerializer;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.NoopKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SchemaRegistryAclAuthorizerUtils;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SchemaRegistryAclReaderThread;
import io.confluent.kafka.schemaregistry.security.config.SecureSchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.rest.Application;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryAclAuthorizer
extends AbstractSchemaRegistryAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryAclAuthorizer.class);
    private SchemaRegistryAclReaderThread aclReaderThread;
    private NoopKey noopKey;
    private int initTimeout;
    private String topic;
    private AclMessageSerializer aclMessageSerializer;
    private Map<String, Map<String, Set<SchemaRegistryResourceOperation>>> subjectAllowedOperations;
    private Map<String, Set<SchemaRegistryResourceOperation>> globalAllowedOperations;
    private static final Map<String, Set<SchemaRegistryResourceOperation>> EMPTY_MAP = new HashMap<String, Set<SchemaRegistryResourceOperation>>();
    private static final Set<SchemaRegistryResourceOperation> EMPTY_SET = EnumSet.noneOf(SchemaRegistryResourceOperation.class);
    private static final String ANY_USER = "*";
    private static final String ANY_SUBJECT = "*";
    private String bootStrapBrokers;
    private SchemaRegistryAclAuthorizerUtils aclAuthorizerUtils;

    void configureAllowedOperations(Map<String, Map<String, Set<SchemaRegistryResourceOperation>>> subjectAllowedOperations, Map<String, Set<SchemaRegistryResourceOperation>> globalAllowedOperations) {
        this.subjectAllowedOperations = subjectAllowedOperations;
        this.globalAllowedOperations = globalAllowedOperations;
    }

    @Override
    public void configure(SchemaRegistryConfig config, SchemaRegistry kafkaSchemaRegistry) throws AuthorizerException {
        super.configure(config, kafkaSchemaRegistry);
        this.initTimeout = config.getInt("kafkastore.init.timeout.ms");
        this.topic = ((SecureSchemaRegistryConfig)config).aclTopic();
        this.noopKey = new NoopKey();
        this.aclMessageSerializer = new AclMessageSerializer();
        this.bootStrapBrokers = config.bootstrapBrokers();
        this.aclAuthorizerUtils = new SchemaRegistryAclAuthorizerUtils(config, this.topic, this.initTimeout, this.bootStrapBrokers, this.aclMessageSerializer, this.noopKey);
        try {
            this.aclAuthorizerUtils.createOrVerifySchemaTopic();
        }
        catch (StoreInitializationException e) {
            throw new AuthorizerException("Couldn't create or verify the ACL topic", e);
        }
        this.subjectAllowedOperations = new ConcurrentHashMap<String, Map<String, Set<SchemaRegistryResourceOperation>>>();
        this.globalAllowedOperations = new ConcurrentHashMap<String, Set<SchemaRegistryResourceOperation>>();
        int port = this.getPortForIdentity(config.getInt("port"), config.getList("listeners"));
        String groupId = String.format("schema-registry-acl-%s-%d", config.getString("host.name"), port);
        this.aclReaderThread = new SchemaRegistryAclReaderThread(config, this.bootStrapBrokers, this.topic, this.noopKey, this.aclMessageSerializer, groupId, this.subjectAllowedOperations, this.globalAllowedOperations);
        this.aclReaderThread.start();
        try {
            this.waitUntilKafkaReaderReachesLastOffset(this.initTimeout);
        }
        catch (StoreException e) {
            throw new AuthorizerException("Couldn't find last offset", e);
        }
        log.info("Initialized Acl Authorizer");
    }

    @Override
    public SchemaRegistryAuthorizer.AuthorizerResult authorizeGlobalOperation(String user, SchemaRegistryResourceOperation schemaRegistryResourceOperation, AuthorizeRequest originalAuthorizeRequest) {
        SchemaRegistryAuthorizer.AuthorizerResult userResult = this.globalOperationFound(user, schemaRegistryResourceOperation);
        SchemaRegistryAuthorizer.AuthorizerResult anyUserResult = this.globalOperationFound("*", schemaRegistryResourceOperation);
        return userResult == SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED || anyUserResult == SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED ? SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED : SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
    }

    @Override
    public SchemaRegistryAuthorizer.AuthorizerResult authorizeSubjectOperation(String user, String subject, SchemaRegistryResourceOperation schemaRegistryResourceOperation, AuthorizeRequest originalAuthorizeRequest) {
        boolean result = this.subjectOperationFound(user, subject, schemaRegistryResourceOperation) || this.subjectOperationFound(user, "*", schemaRegistryResourceOperation) || this.subjectOperationFound("*", subject, schemaRegistryResourceOperation) || this.subjectOperationFound("*", "*", schemaRegistryResourceOperation) || this.subjectPatternOperationFound(user, subject, schemaRegistryResourceOperation);
        QualifiedSubject qs = QualifiedSubject.create((String)this.schemaRegistry().tenant(), (String)subject);
        String context = qs.getContext();
        if (!".".equals(context)) {
            String normalizedContext = QualifiedSubject.normalizeContext((String)context);
            result = result || this.subjectOperationFound(user, normalizedContext, schemaRegistryResourceOperation) || this.subjectOperationFound("*", normalizedContext, schemaRegistryResourceOperation);
        }
        return result ? SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED : SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
    }

    @Override
    public SchemaRegistryAuthorizer.AuthorizerResult authorizeKekOperation(String user, String kekName, SchemaRegistryResourceOperation schemaRegistryResourceOperation, AuthorizeRequest originalAuthorizeRequest) {
        return SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED;
    }

    @Override
    public void shutdown() {
        this.aclReaderThread.shutdown();
        this.aclAuthorizerUtils.shutdown();
    }

    private boolean subjectOperationFound(String user, String subject, SchemaRegistryResourceOperation schemaRegistryResourceOperation) {
        boolean result = this.getOrDefault(this.getOrDefault(this.subjectAllowedOperations, user, EMPTY_MAP), subject, EMPTY_SET).contains((Object)schemaRegistryResourceOperation);
        log.debug("Subject operation {} search {} for user {} and subject {}", new Object[]{schemaRegistryResourceOperation.toString(), result ? "SUCCESSFUL" : "FAILED", user != null ? user : "N/A", subject != null ? subject : "N/A"});
        return result;
    }

    private boolean subjectPatternOperationFound(String user, String subject, SchemaRegistryResourceOperation schemaRegistryResourceOperation) {
        boolean result = false;
        Map<String, Set<SchemaRegistryResourceOperation>> userMap = this.getOrDefault(this.subjectAllowedOperations, user, EMPTY_MAP);
        for (Map.Entry<String, Set<SchemaRegistryResourceOperation>> subjectPatternEntry : userMap.entrySet()) {
            String regex;
            String subjectPattern = subjectPatternEntry.getKey();
            if (!subjectPattern.contains("*") || !subject.matches(regex = subjectPattern.replaceAll(".", "[$0]").replace("[*]", ".*")) || !subjectPatternEntry.getValue().contains((Object)schemaRegistryResourceOperation)) continue;
            result = true;
            break;
        }
        log.debug("Subject Pattern operation {} search {} for user {} and subject {}", new Object[]{schemaRegistryResourceOperation.toString(), result ? "SUCCESSFUL" : "FAILED", user != null ? user : "N/A", subject != null ? subject : "N/A"});
        return result;
    }

    private SchemaRegistryAuthorizer.AuthorizerResult globalOperationFound(String user, SchemaRegistryResourceOperation schemaRegistryResourceOperation) {
        boolean result = this.getOrDefault(this.globalAllowedOperations, user, EMPTY_SET).contains((Object)schemaRegistryResourceOperation);
        log.debug("Global operation {} search {} for user {}", new Object[]{schemaRegistryResourceOperation.toString(), result ? "SUCCESSFUL" : "FAILED", user != null ? user : "N/A"});
        return result ? SchemaRegistryAuthorizer.AuthorizerResult.ALLOWED : SchemaRegistryAuthorizer.AuthorizerResult.DENIED;
    }

    private void waitUntilKafkaReaderReachesLastOffset(int timeoutMs) throws StoreException {
        long offsetOfLastMessage = this.aclAuthorizerUtils.getLatestOffset(timeoutMs);
        log.info("Reading ACL information from Kafka (final offset: " + offsetOfLastMessage + ")");
        this.aclReaderThread.waitUntilOffset(offsetOfLastMessage, timeoutMs, TimeUnit.MILLISECONDS);
        log.info("Finished reading ACL information");
    }

    private <T> T getOrDefault(Map<String, T> map, String key, T def) {
        return map.containsKey(key) ? map.get(key) : def;
    }

    private int getPortForIdentity(int port, List<String> configuredListeners) {
        List listeners = Application.parseListeners(configuredListeners, (int)port, Arrays.asList("http", "https"), (String)"http");
        return ((URI)listeners.get(0)).getPort();
    }
}

