/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.AclMessageSerializer;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.GlobalAclKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.GlobalAclValue;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.NoopKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SchemaRegistryAclKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SchemaRegistryAclValue;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SubjectAclKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SubjectAclValue;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.exceptions.SerializationException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreTimeoutException;
import io.confluent.kafka.schemaregistry.utils.ShutdownableThread;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryAclReaderThread
extends ShutdownableThread {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryAclReaderThread.class);
    private final TopicPartition topicPartition;
    private final String topic;
    private Consumer<byte[], byte[]> consumer;
    private long offsetInSchemasTopic = -1L;
    private final NoopKey noopKey;
    private final ReentrantLock offsetUpdateLock;
    private final Condition offsetReachedThreshold;
    private Properties consumerProps = new Properties();
    private final AclMessageSerializer aclMessageSerializer;
    private Map<String, Map<String, Set<SchemaRegistryResourceOperation>>> subjectAllowedOperations;
    private Map<String, Set<SchemaRegistryResourceOperation>> globalAllowedOperations;

    public SchemaRegistryAclReaderThread(SchemaRegistryConfig config, String bootStrapBrokers, String topic, NoopKey noopKey, AclMessageSerializer aclMessageSerializer, String groupId, Map<String, Map<String, Set<SchemaRegistryResourceOperation>>> subjectAllowedOperations, Map<String, Set<SchemaRegistryResourceOperation>> globalAllowedOperations) {
        super("schema-registry-acl-reader-thread", false);
        this.topic = topic;
        this.offsetUpdateLock = new ReentrantLock();
        this.offsetReachedThreshold = this.offsetUpdateLock.newCondition();
        this.noopKey = noopKey;
        this.aclMessageSerializer = aclMessageSerializer;
        this.subjectAllowedOperations = subjectAllowedOperations;
        this.globalAllowedOperations = globalAllowedOperations;
        KafkaStore.addSchemaRegistryConfigsToClientProperties((SchemaRegistryConfig)config, (Properties)this.consumerProps);
        this.consumerProps.put("group.id", groupId);
        this.consumerProps.put("client.id", "schema-registry-acl-reader");
        this.consumerProps.put("bootstrap.servers", bootStrapBrokers);
        this.consumerProps.put("auto.offset.reset", "earliest");
        this.consumerProps.put("enable.auto.commit", "false");
        this.consumerProps.put("key.deserializer", ByteArrayDeserializer.class);
        this.consumerProps.put("value.deserializer", ByteArrayDeserializer.class);
        this.consumerProps.put("security.protocol", config.getString("kafkastore.security.protocol"));
        this.consumer = new KafkaConsumer(this.consumerProps);
        int retries = 0;
        List partitions = null;
        while (retries++ < 10 && ((partitions = this.consumer.partitionsFor(this.topic)) == null || partitions.size() < 1)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (partitions == null || partitions.size() < 1) {
            throw new IllegalArgumentException("Unable to subscribe to the Kafka topic " + topic + " backing this data store. Topic may not exist.");
        }
        this.topicPartition = new TopicPartition(topic, 0);
        this.consumer.assign(Arrays.asList(this.topicPartition));
        this.consumer.seekToBeginning(Arrays.asList(this.topicPartition));
        log.info("Initialized last consumed offset to " + this.offsetInSchemasTopic);
    }

    public void doWork() {
        try {
            ConsumerRecords records = this.consumer.poll(Duration.ofMillis(Long.MAX_VALUE));
            for (ConsumerRecord record : records) {
                SchemaRegistryAclKey messageKey;
                try {
                    messageKey = this.aclMessageSerializer.deserializeSchemaRegistryAclKey((byte[])record.key());
                    log.debug("Message key is " + String.valueOf(messageKey));
                }
                catch (SerializationException e) {
                    log.error("Failed to deserialize the key", (Throwable)e);
                    continue;
                }
                if (!this.noopKey.equals(messageKey)) {
                    try {
                        this.handleSchemaRegistryAclValue((ConsumerRecord<byte[], byte[]>)record, messageKey);
                    }
                    catch (SerializationException e) {
                        log.error("Failed to deserialize the value", (Throwable)e);
                        continue;
                    }
                }
                this.updateOffset(record);
            }
        }
        catch (WakeupException records) {
        }
        catch (RecordTooLargeException rtle) {
            throw new IllegalStateException("Consumer threw RecordTooLargeException. A schema has been written that exceeds the default maximum fetch size.", rtle);
        }
        catch (RuntimeException e) {
            log.error("KafkaStoreReader thread has died for an unknown reason.");
            throw e;
        }
    }

    private void handleSchemaRegistryAclValue(ConsumerRecord<byte[], byte[]> record, SchemaRegistryAclKey messageKey) throws SerializationException {
        SchemaRegistryAclValue schemaRegistryAclValue = this.aclMessageSerializer.deserializeSchemaRegistryAclValue(messageKey.getKeyType(), (byte[])record.value());
        log.debug("The ACL value is " + String.valueOf(schemaRegistryAclValue));
        if (messageKey instanceof SubjectAclKey) {
            this.handleSubjectAclValue((SubjectAclKey)messageKey, (SubjectAclValue)schemaRegistryAclValue);
        }
        if (messageKey instanceof GlobalAclKey) {
            this.handleGlobalAclValue((GlobalAclKey)messageKey, (GlobalAclValue)schemaRegistryAclValue);
        }
    }

    private void handleGlobalAclValue(GlobalAclKey globalAclKey, GlobalAclValue globalAclValue) {
        if (globalAclValue == null || this.isEmptyCollection(globalAclValue.getAuthorizedOperations())) {
            if (this.globalAllowedOperations.containsKey(globalAclKey.getPrincipal())) {
                this.globalAllowedOperations.remove(globalAclKey.getPrincipal());
            }
        } else {
            this.globalAllowedOperations.put(globalAclValue.getPrincipal(), EnumSet.copyOf(globalAclValue.getAuthorizedOperations()));
        }
    }

    private void handleSubjectAclValue(SubjectAclKey subjectAclKey, SubjectAclValue subjectAclValue) {
        if (subjectAclValue == null || this.isEmptyCollection(subjectAclValue.getAllowedOperations())) {
            if (this.subjectAllowedOperations.containsKey(subjectAclKey.getPrincipal())) {
                this.subjectAllowedOperations.get(subjectAclKey.getPrincipal()).remove(subjectAclKey.getSubject());
                if (this.subjectAllowedOperations.get(subjectAclKey.getPrincipal()).size() == 0) {
                    this.subjectAllowedOperations.remove(subjectAclKey.getPrincipal());
                }
            }
        } else {
            if (this.subjectAllowedOperations.get(subjectAclValue.getPrincipal()) == null) {
                this.subjectAllowedOperations.put(subjectAclValue.getPrincipal(), new ConcurrentHashMap());
            }
            this.subjectAllowedOperations.get(subjectAclValue.getPrincipal()).put(subjectAclValue.getSubject(), EnumSet.copyOf(subjectAclValue.getAllowedOperations()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilOffset(long offset, long timeout, TimeUnit timeUnit) throws StoreException {
        if (offset < 0L) {
            throw new StoreException("SchemaRegistryAclReaderThread can't wait for a negative offset.");
        }
        log.trace("Waiting to read offset {}. Currently at offset {}", (Object)offset, (Object)this.offsetInSchemasTopic);
        try {
            this.offsetUpdateLock.lock();
            long timeoutNs = TimeUnit.NANOSECONDS.convert(timeout, timeUnit);
            while (this.offsetInSchemasTopic < offset && timeoutNs > 0L) {
                try {
                    timeoutNs = this.offsetReachedThreshold.awaitNanos(timeoutNs);
                }
                catch (InterruptedException e) {
                    log.debug("Interrupted while waiting for the background acl reader thread to reach the specified offset: " + offset, (Throwable)e);
                }
            }
        }
        finally {
            this.offsetUpdateLock.unlock();
        }
        if (this.offsetInSchemasTopic < offset) {
            throw new StoreTimeoutException("SchemaRegistryAclReaderThread failed to reach target offset within the timeout interval. targetOffset: " + offset + ", offsetReached: " + this.offsetInSchemasTopic + ", timeout(ms): " + TimeUnit.MILLISECONDS.convert(timeout, timeUnit));
        }
    }

    private void updateOffset(ConsumerRecord record) {
        try {
            this.offsetUpdateLock.lock();
            this.offsetInSchemasTopic = record.offset();
            log.debug("The offset is " + this.offsetInSchemasTopic);
            this.offsetReachedThreshold.signalAll();
        }
        finally {
            this.offsetUpdateLock.unlock();
        }
    }

    private boolean isEmptyCollection(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public void shutdown() {
        try {
            log.debug("Starting shutdown of SchemaRegistryAclReaderThread.");
            super.initiateShutdown();
            if (this.consumer != null) {
                this.consumer.wakeup();
            }
            super.awaitShutdown();
            if (this.consumer != null) {
                this.consumer.close();
            }
            log.info("SchemaRegistryAclReaderThread shutdown complete.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

